/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountIds;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountOrderByEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountPage;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class AccountRoutesApi {
    private ApiClient apiClient;

    public AccountRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AccountInfoDTO getAccountInfo(String accountId) throws ApiException {
        return this.getAccountInfoWithHttpInfo(accountId).getData();
    }

    public ApiResponse<AccountInfoDTO> getAccountInfoWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountInfo");
        }
        String localVarPath = "/accounts/{accountId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AccountInfoDTO> localVarReturnType = new GenericType<AccountInfoDTO>(){};
        return this.apiClient.invokeAPI("AccountRoutesApi.getAccountInfo", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AccountInfoDTO> getAccountsInfo(AccountIds accountIds) throws ApiException {
        return this.getAccountsInfoWithHttpInfo(accountIds).getData();
    }

    public ApiResponse<List<AccountInfoDTO>> getAccountsInfoWithHttpInfo(AccountIds accountIds) throws ApiException {
        AccountIds localVarPostBody = accountIds;
        String localVarPath = "/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<AccountInfoDTO>> localVarReturnType = new GenericType<List<AccountInfoDTO>>(){};
        return this.apiClient.invokeAPI("AccountRoutesApi.getAccountsInfo", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AccountPage searchAccounts(Integer pageSize, Integer pageNumber, String offset, Order order, AccountOrderByEnum orderBy, String mosaicId) throws ApiException {
        return this.searchAccountsWithHttpInfo(pageSize, pageNumber, offset, order, orderBy, mosaicId).getData();
    }

    public ApiResponse<AccountPage> searchAccountsWithHttpInfo(Integer pageSize, Integer pageNumber, String offset, Order order, AccountOrderByEnum orderBy, String mosaicId) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "orderBy", (Object)orderBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "mosaicId", mosaicId));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AccountPage> localVarReturnType = new GenericType<AccountPage>(){};
        return this.apiClient.invokeAPI("AccountRoutesApi.searchAccounts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

