package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.AccountIds;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountRestrictionsInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-26T18:32:22.702Z[UTC]")
public class RestrictionAccountRoutesApi {
  private ApiClient apiClient;

  public RestrictionAccountRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public RestrictionAccountRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Get the account restrictions
   * Returns the account restrictions for a given account.
   * @param accountId Account public key or address enconded using a 32-character set. (required)
   * @return AccountRestrictionsInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public AccountRestrictionsInfoDTO getAccountRestrictions(String accountId) throws ApiException {
    return getAccountRestrictionsWithHttpInfo(accountId).getData();
  }

  /**
   * Get the account restrictions
   * Returns the account restrictions for a given account.
   * @param accountId Account public key or address enconded using a 32-character set. (required)
   * @return ApiResponse&lt;AccountRestrictionsInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<AccountRestrictionsInfoDTO> getAccountRestrictionsWithHttpInfo(String accountId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountRestrictions");
    }
    
    // create path and map variables
    String localVarPath = "/restrictions/account/{accountId}"
      .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<AccountRestrictionsInfoDTO> localVarReturnType = new GenericType<AccountRestrictionsInfoDTO>() {};
    return apiClient.invokeAPI("RestrictionAccountRoutesApi.getAccountRestrictions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get account restrictions for given array of addresses
   * Returns the account restrictions for a given array of addresses.
   * @param accountIds  (optional)
   * @return List&lt;AccountRestrictionsInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<AccountRestrictionsInfoDTO> getAccountRestrictionsFromAccounts(AccountIds accountIds) throws ApiException {
    return getAccountRestrictionsFromAccountsWithHttpInfo(accountIds).getData();
  }

  /**
   * Get account restrictions for given array of addresses
   * Returns the account restrictions for a given array of addresses.
   * @param accountIds  (optional)
   * @return ApiResponse&lt;List&lt;AccountRestrictionsInfoDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<AccountRestrictionsInfoDTO>> getAccountRestrictionsFromAccountsWithHttpInfo(AccountIds accountIds) throws ApiException {
    Object localVarPostBody = accountIds;
    
    // create path and map variables
    String localVarPath = "/restrictions/account";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<AccountRestrictionsInfoDTO>> localVarReturnType = new GenericType<List<AccountRestrictionsInfoDTO>>() {};
    return apiClient.invokeAPI("RestrictionAccountRoutesApi.getAccountRestrictionsFromAccounts", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
