package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.MetadataDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.MetadataEntriesDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-26T18:32:22.702Z[UTC]")
public class MetadataRoutesApi {
  private ApiClient apiClient;

  public MetadataRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public MetadataRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Get account metadata
   * Returns the account metadata given an account id.
   * @param address Account address. (required)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @return MetadataEntriesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataEntriesDTO getAccountMetadata(String address, Integer pageSize, Order order, String id) throws ApiException {
    return getAccountMetadataWithHttpInfo(address, pageSize, order, id).getData();
  }

  /**
   * Get account metadata
   * Returns the account metadata given an account id.
   * @param address Account address. (required)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @return ApiResponse&lt;MetadataEntriesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataEntriesDTO> getAccountMetadataWithHttpInfo(String address, Integer pageSize, Order order, String id) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'address' is set
    if (address == null) {
      throw new ApiException(400, "Missing the required parameter 'address' when calling getAccountMetadata");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/account/{address}"
      .replaceAll("\\{" + "address" + "\\}", apiClient.escapeString(address.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>() {};
    return apiClient.invokeAPI("MetadataRoutesApi.getAccountMetadata", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get account metadata
   * Returns the account metadata given an account id and a key.
   * @param address Account address. (required)
   * @param key Metadata key. (required)
   * @return MetadataEntriesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataEntriesDTO getAccountMetadataByKey(String address, String key) throws ApiException {
    return getAccountMetadataByKeyWithHttpInfo(address, key).getData();
  }

  /**
   * Get account metadata
   * Returns the account metadata given an account id and a key.
   * @param address Account address. (required)
   * @param key Metadata key. (required)
   * @return ApiResponse&lt;MetadataEntriesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataEntriesDTO> getAccountMetadataByKeyWithHttpInfo(String address, String key) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'address' is set
    if (address == null) {
      throw new ApiException(400, "Missing the required parameter 'address' when calling getAccountMetadataByKey");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getAccountMetadataByKey");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/account/{address}/key/{key}"
      .replaceAll("\\{" + "address" + "\\}", apiClient.escapeString(address.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>() {};
    return apiClient.invokeAPI("MetadataRoutesApi.getAccountMetadataByKey", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get account metadata
   * Returns the account metadata given an account id, a key, and a sender.
   * @param address Account address. (required)
   * @param key Metadata key. (required)
   * @param sourceAddress Account address. (required)
   * @return MetadataDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataDTO getAccountMetadataByKeyAndSender(String address, String key, String sourceAddress) throws ApiException {
    return getAccountMetadataByKeyAndSenderWithHttpInfo(address, key, sourceAddress).getData();
  }

  /**
   * Get account metadata
   * Returns the account metadata given an account id, a key, and a sender.
   * @param address Account address. (required)
   * @param key Metadata key. (required)
   * @param sourceAddress Account address. (required)
   * @return ApiResponse&lt;MetadataDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataDTO> getAccountMetadataByKeyAndSenderWithHttpInfo(String address, String key, String sourceAddress) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'address' is set
    if (address == null) {
      throw new ApiException(400, "Missing the required parameter 'address' when calling getAccountMetadataByKeyAndSender");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getAccountMetadataByKeyAndSender");
    }
    
    // verify the required parameter 'sourceAddress' is set
    if (sourceAddress == null) {
      throw new ApiException(400, "Missing the required parameter 'sourceAddress' when calling getAccountMetadataByKeyAndSender");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/account/{address}/key/{key}/sender/{sourceAddress}"
      .replaceAll("\\{" + "address" + "\\}", apiClient.escapeString(address.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "sourceAddress" + "\\}", apiClient.escapeString(sourceAddress.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataDTO> localVarReturnType = new GenericType<MetadataDTO>() {};
    return apiClient.invokeAPI("MetadataRoutesApi.getAccountMetadataByKeyAndSender", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get mosaic metadata
   * Returns the mosaic metadata given a mosaic id.
   * @param mosaicId Mosaic identifier. (required)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return MetadataEntriesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataEntriesDTO getMosaicMetadata(String mosaicId, Integer pageSize, String id, Order order) throws ApiException {
    return getMosaicMetadataWithHttpInfo(mosaicId, pageSize, id, order).getData();
  }

  /**
   * Get mosaic metadata
   * Returns the mosaic metadata given a mosaic id.
   * @param mosaicId Mosaic identifier. (required)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ApiResponse&lt;MetadataEntriesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataEntriesDTO> getMosaicMetadataWithHttpInfo(String mosaicId, Integer pageSize, String id, Order order) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'mosaicId' is set
    if (mosaicId == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadata");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/mosaic/{mosaicId}"
      .replaceAll("\\{" + "mosaicId" + "\\}", apiClient.escapeString(mosaicId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>() {};
    return apiClient.invokeAPI("MetadataRoutesApi.getMosaicMetadata", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get mosaic metadata
   * Returns the mosaic metadata given a mosaic id and a key.
   * @param mosaicId Mosaic identifier. (required)
   * @param key Metadata key. (required)
   * @return MetadataEntriesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataEntriesDTO getMosaicMetadataByKey(String mosaicId, String key) throws ApiException {
    return getMosaicMetadataByKeyWithHttpInfo(mosaicId, key).getData();
  }

  /**
   * Get mosaic metadata
   * Returns the mosaic metadata given a mosaic id and a key.
   * @param mosaicId Mosaic identifier. (required)
   * @param key Metadata key. (required)
   * @return ApiResponse&lt;MetadataEntriesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataEntriesDTO> getMosaicMetadataByKeyWithHttpInfo(String mosaicId, String key) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'mosaicId' is set
    if (mosaicId == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKey");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getMosaicMetadataByKey");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}"
      .replaceAll("\\{" + "mosaicId" + "\\}", apiClient.escapeString(mosaicId.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>() {};
    return apiClient.invokeAPI("MetadataRoutesApi.getMosaicMetadataByKey", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get mosaic metadata
   * Returns the mosaic metadata given a mosaic id, a key, and a sender.
   * @param mosaicId Mosaic identifier. (required)
   * @param key Metadata key. (required)
   * @param sourceAddress Account address. (required)
   * @return MetadataDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataDTO getMosaicMetadataByKeyAndSender(String mosaicId, String key, String sourceAddress) throws ApiException {
    return getMosaicMetadataByKeyAndSenderWithHttpInfo(mosaicId, key, sourceAddress).getData();
  }

  /**
   * Get mosaic metadata
   * Returns the mosaic metadata given a mosaic id, a key, and a sender.
   * @param mosaicId Mosaic identifier. (required)
   * @param key Metadata key. (required)
   * @param sourceAddress Account address. (required)
   * @return ApiResponse&lt;MetadataDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataDTO> getMosaicMetadataByKeyAndSenderWithHttpInfo(String mosaicId, String key, String sourceAddress) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'mosaicId' is set
    if (mosaicId == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKeyAndSender");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getMosaicMetadataByKeyAndSender");
    }
    
    // verify the required parameter 'sourceAddress' is set
    if (sourceAddress == null) {
      throw new ApiException(400, "Missing the required parameter 'sourceAddress' when calling getMosaicMetadataByKeyAndSender");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}/sender/{sourceAddress}"
      .replaceAll("\\{" + "mosaicId" + "\\}", apiClient.escapeString(mosaicId.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "sourceAddress" + "\\}", apiClient.escapeString(sourceAddress.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataDTO> localVarReturnType = new GenericType<MetadataDTO>() {};
    return apiClient.invokeAPI("MetadataRoutesApi.getMosaicMetadataByKeyAndSender", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get namespace metadata
   * Returns the namespace metadata given a namespace id.
   * @param namespaceId Namespace identifier. (required)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return MetadataEntriesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataEntriesDTO getNamespaceMetadata(String namespaceId, Integer pageSize, String id, Order order) throws ApiException {
    return getNamespaceMetadataWithHttpInfo(namespaceId, pageSize, id, order).getData();
  }

  /**
   * Get namespace metadata
   * Returns the namespace metadata given a namespace id.
   * @param namespaceId Namespace identifier. (required)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ApiResponse&lt;MetadataEntriesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataEntriesDTO> getNamespaceMetadataWithHttpInfo(String namespaceId, Integer pageSize, String id, Order order) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'namespaceId' is set
    if (namespaceId == null) {
      throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadata");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/namespace/{namespaceId}"
      .replaceAll("\\{" + "namespaceId" + "\\}", apiClient.escapeString(namespaceId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>() {};
    return apiClient.invokeAPI("MetadataRoutesApi.getNamespaceMetadata", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get namespace metadata
   * Returns the namespace metadata given a namespace id and a key.
   * @param namespaceId Namespace identifier. (required)
   * @param key Metadata key. (required)
   * @return MetadataEntriesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataEntriesDTO getNamespaceMetadataByKey(String namespaceId, String key) throws ApiException {
    return getNamespaceMetadataByKeyWithHttpInfo(namespaceId, key).getData();
  }

  /**
   * Get namespace metadata
   * Returns the namespace metadata given a namespace id and a key.
   * @param namespaceId Namespace identifier. (required)
   * @param key Metadata key. (required)
   * @return ApiResponse&lt;MetadataEntriesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataEntriesDTO> getNamespaceMetadataByKeyWithHttpInfo(String namespaceId, String key) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'namespaceId' is set
    if (namespaceId == null) {
      throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKey");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getNamespaceMetadataByKey");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}"
      .replaceAll("\\{" + "namespaceId" + "\\}", apiClient.escapeString(namespaceId.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>() {};
    return apiClient.invokeAPI("MetadataRoutesApi.getNamespaceMetadataByKey", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get namespace metadata
   * Returns the namespace metadata given a namespace id, a key, and a sender.
   * @param namespaceId Namespace identifier. (required)
   * @param key Metadata key. (required)
   * @param sourceAddress Account address. (required)
   * @return MetadataDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataDTO getNamespaceMetadataByKeyAndSender(String namespaceId, String key, String sourceAddress) throws ApiException {
    return getNamespaceMetadataByKeyAndSenderWithHttpInfo(namespaceId, key, sourceAddress).getData();
  }

  /**
   * Get namespace metadata
   * Returns the namespace metadata given a namespace id, a key, and a sender.
   * @param namespaceId Namespace identifier. (required)
   * @param key Metadata key. (required)
   * @param sourceAddress Account address. (required)
   * @return ApiResponse&lt;MetadataDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataDTO> getNamespaceMetadataByKeyAndSenderWithHttpInfo(String namespaceId, String key, String sourceAddress) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'namespaceId' is set
    if (namespaceId == null) {
      throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKeyAndSender");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getNamespaceMetadataByKeyAndSender");
    }
    
    // verify the required parameter 'sourceAddress' is set
    if (sourceAddress == null) {
      throw new ApiException(400, "Missing the required parameter 'sourceAddress' when calling getNamespaceMetadataByKeyAndSender");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}/sender/{sourceAddress}"
      .replaceAll("\\{" + "namespaceId" + "\\}", apiClient.escapeString(namespaceId.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "sourceAddress" + "\\}", apiClient.escapeString(sourceAddress.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataDTO> localVarReturnType = new GenericType<MetadataDTO>() {};
    return apiClient.invokeAPI("MetadataRoutesApi.getNamespaceMetadataByKeyAndSender", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
