/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.jersey2.model.MessageDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.UnresolvedMosaic;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"recipientAddress", "mosaics", "message"})
public class TransferTransactionBodyDTO {
    public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
    private String recipientAddress;
    public static final String JSON_PROPERTY_MOSAICS = "mosaics";
    private List<UnresolvedMosaic> mosaics = new ArrayList<UnresolvedMosaic>();
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private MessageDTO message;

    public TransferTransactionBodyDTO recipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E01A", required=true, value="Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
    @JsonProperty(value="recipientAddress")
    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public TransferTransactionBodyDTO mosaics(List<UnresolvedMosaic> mosaics) {
        this.mosaics = mosaics;
        return this;
    }

    public TransferTransactionBodyDTO addMosaicsItem(UnresolvedMosaic mosaicsItem) {
        this.mosaics.add(mosaicsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of mosaics sent to the recipient. ")
    @JsonProperty(value="mosaics")
    public List<UnresolvedMosaic> getMosaics() {
        return this.mosaics;
    }

    public void setMosaics(List<UnresolvedMosaic> mosaics) {
        this.mosaics = mosaics;
    }

    public TransferTransactionBodyDTO message(MessageDTO message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="message")
    public MessageDTO getMessage() {
        return this.message;
    }

    public void setMessage(MessageDTO message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferTransactionBodyDTO transferTransactionBodyDTO = (TransferTransactionBodyDTO)o;
        return Objects.equals(this.recipientAddress, transferTransactionBodyDTO.recipientAddress) && Objects.equals(this.mosaics, transferTransactionBodyDTO.mosaics) && Objects.equals(this.message, transferTransactionBodyDTO.message);
    }

    public int hashCode() {
        return Objects.hash(this.recipientAddress, this.mosaics, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferTransactionBodyDTO {\n");
        sb.append("    recipientAddress: ").append(this.toIndentedString(this.recipientAddress)).append("\n");
        sb.append("    mosaics: ").append(this.toIndentedString(this.mosaics)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

