/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.jersey2.model.LockHashAlgorithmEnum;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@JsonPropertyOrder(value={"secret", "mosaicId", "amount", "duration", "hashAlgorithm", "recipientAddress"})
public class SecretLockTransactionBodyDTO {
    public static final String JSON_PROPERTY_SECRET = "secret";
    private String secret;
    public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
    private String mosaicId;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private BigInteger amount = null;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private BigInteger duration = null;
    public static final String JSON_PROPERTY_HASH_ALGORITHM = "hashAlgorithm";
    private LockHashAlgorithmEnum hashAlgorithm;
    public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
    private String recipientAddress;

    public SecretLockTransactionBodyDTO secret(String secret) {
        this.secret = secret;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="secret")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SecretLockTransactionBodyDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
    @JsonProperty(value="mosaicId")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public SecretLockTransactionBodyDTO amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="amount")
    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public SecretLockTransactionBodyDTO duration(BigInteger duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    @JsonProperty(value="duration")
    public BigInteger getDuration() {
        return this.duration;
    }

    public void setDuration(BigInteger duration) {
        this.duration = duration;
    }

    public SecretLockTransactionBodyDTO hashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="hashAlgorithm")
    public LockHashAlgorithmEnum getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public SecretLockTransactionBodyDTO recipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E01A", required=true, value="Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
    @JsonProperty(value="recipientAddress")
    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretLockTransactionBodyDTO secretLockTransactionBodyDTO = (SecretLockTransactionBodyDTO)o;
        return Objects.equals(this.secret, secretLockTransactionBodyDTO.secret) && Objects.equals(this.mosaicId, secretLockTransactionBodyDTO.mosaicId) && Objects.equals(this.amount, secretLockTransactionBodyDTO.amount) && Objects.equals(this.duration, secretLockTransactionBodyDTO.duration) && Objects.equals((Object)this.hashAlgorithm, (Object)secretLockTransactionBodyDTO.hashAlgorithm) && Objects.equals(this.recipientAddress, secretLockTransactionBodyDTO.recipientAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.secret, this.mosaicId, this.amount, this.duration, this.hashAlgorithm, this.recipientAddress});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecretLockTransactionBodyDTO {\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    hashAlgorithm: ").append(this.toIndentedString((Object)this.hashAlgorithm)).append("\n");
        sb.append("    recipientAddress: ").append(this.toIndentedString(this.recipientAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

