/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Chain related configuration properties.")
@JsonPropertyOrder(value={"enableVerifiableState", "enableVerifiableReceipts", "currencyMosaicId", "harvestingMosaicId", "blockGenerationTargetTime", "blockTimeSmoothingFactor", "importanceGrouping", "importanceActivityPercentage", "maxRollbackBlocks", "maxDifficultyBlocks", "defaultDynamicFeeMultiplier", "maxTransactionLifetime", "maxBlockFutureTime", "initialCurrencyAtomicUnits", "maxMosaicAtomicUnits", "totalChainImportance", "minHarvesterBalance", "maxHarvesterBalance", "harvestBeneficiaryPercentage", "blockPruneInterval", "maxTransactionsPerBlock"})
public class ChainPropertiesDTO {
    public static final String JSON_PROPERTY_ENABLE_VERIFIABLE_STATE = "enableVerifiableState";
    private Boolean enableVerifiableState;
    public static final String JSON_PROPERTY_ENABLE_VERIFIABLE_RECEIPTS = "enableVerifiableReceipts";
    private Boolean enableVerifiableReceipts;
    public static final String JSON_PROPERTY_CURRENCY_MOSAIC_ID = "currencyMosaicId";
    private String currencyMosaicId;
    public static final String JSON_PROPERTY_HARVESTING_MOSAIC_ID = "harvestingMosaicId";
    private String harvestingMosaicId;
    public static final String JSON_PROPERTY_BLOCK_GENERATION_TARGET_TIME = "blockGenerationTargetTime";
    private String blockGenerationTargetTime;
    public static final String JSON_PROPERTY_BLOCK_TIME_SMOOTHING_FACTOR = "blockTimeSmoothingFactor";
    private String blockTimeSmoothingFactor;
    public static final String JSON_PROPERTY_IMPORTANCE_GROUPING = "importanceGrouping";
    private String importanceGrouping;
    public static final String JSON_PROPERTY_IMPORTANCE_ACTIVITY_PERCENTAGE = "importanceActivityPercentage";
    private String importanceActivityPercentage;
    public static final String JSON_PROPERTY_MAX_ROLLBACK_BLOCKS = "maxRollbackBlocks";
    private String maxRollbackBlocks;
    public static final String JSON_PROPERTY_MAX_DIFFICULTY_BLOCKS = "maxDifficultyBlocks";
    private String maxDifficultyBlocks;
    public static final String JSON_PROPERTY_DEFAULT_DYNAMIC_FEE_MULTIPLIER = "defaultDynamicFeeMultiplier";
    private String defaultDynamicFeeMultiplier;
    public static final String JSON_PROPERTY_MAX_TRANSACTION_LIFETIME = "maxTransactionLifetime";
    private String maxTransactionLifetime;
    public static final String JSON_PROPERTY_MAX_BLOCK_FUTURE_TIME = "maxBlockFutureTime";
    private String maxBlockFutureTime;
    public static final String JSON_PROPERTY_INITIAL_CURRENCY_ATOMIC_UNITS = "initialCurrencyAtomicUnits";
    private String initialCurrencyAtomicUnits;
    public static final String JSON_PROPERTY_MAX_MOSAIC_ATOMIC_UNITS = "maxMosaicAtomicUnits";
    private String maxMosaicAtomicUnits;
    public static final String JSON_PROPERTY_TOTAL_CHAIN_IMPORTANCE = "totalChainImportance";
    private String totalChainImportance;
    public static final String JSON_PROPERTY_MIN_HARVESTER_BALANCE = "minHarvesterBalance";
    private String minHarvesterBalance;
    public static final String JSON_PROPERTY_MAX_HARVESTER_BALANCE = "maxHarvesterBalance";
    private String maxHarvesterBalance;
    public static final String JSON_PROPERTY_HARVEST_BENEFICIARY_PERCENTAGE = "harvestBeneficiaryPercentage";
    private String harvestBeneficiaryPercentage;
    public static final String JSON_PROPERTY_BLOCK_PRUNE_INTERVAL = "blockPruneInterval";
    private String blockPruneInterval;
    public static final String JSON_PROPERTY_MAX_TRANSACTIONS_PER_BLOCK = "maxTransactionsPerBlock";
    private String maxTransactionsPerBlock;

    public ChainPropertiesDTO enableVerifiableState(Boolean enableVerifiableState) {
        this.enableVerifiableState = enableVerifiableState;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Set to true if block chain should calculate state hashes so that state is fully verifiable at each block.")
    @JsonProperty(value="enableVerifiableState")
    public Boolean getEnableVerifiableState() {
        return this.enableVerifiableState;
    }

    public void setEnableVerifiableState(Boolean enableVerifiableState) {
        this.enableVerifiableState = enableVerifiableState;
    }

    public ChainPropertiesDTO enableVerifiableReceipts(Boolean enableVerifiableReceipts) {
        this.enableVerifiableReceipts = enableVerifiableReceipts;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Set to true if block chain should calculate receipts so that state changes are fully verifiable at each block.")
    @JsonProperty(value="enableVerifiableReceipts")
    public Boolean getEnableVerifiableReceipts() {
        return this.enableVerifiableReceipts;
    }

    public void setEnableVerifiableReceipts(Boolean enableVerifiableReceipts) {
        this.enableVerifiableReceipts = enableVerifiableReceipts;
    }

    public ChainPropertiesDTO currencyMosaicId(String currencyMosaicId) {
        this.currencyMosaicId = currencyMosaicId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0x621E'C5B4'0385'6FC2", value="Mosaic id used as primary chain currency.")
    @JsonProperty(value="currencyMosaicId")
    public String getCurrencyMosaicId() {
        return this.currencyMosaicId;
    }

    public void setCurrencyMosaicId(String currencyMosaicId) {
        this.currencyMosaicId = currencyMosaicId;
    }

    public ChainPropertiesDTO harvestingMosaicId(String harvestingMosaicId) {
        this.harvestingMosaicId = harvestingMosaicId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0x4291'ED23'000A'037A", value="Mosaic id used to provide harvesting ability.")
    @JsonProperty(value="harvestingMosaicId")
    public String getHarvestingMosaicId() {
        return this.harvestingMosaicId;
    }

    public void setHarvestingMosaicId(String harvestingMosaicId) {
        this.harvestingMosaicId = harvestingMosaicId;
    }

    public ChainPropertiesDTO blockGenerationTargetTime(String blockGenerationTargetTime) {
        this.blockGenerationTargetTime = blockGenerationTargetTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="15s", value="Targeted time between blocks.")
    @JsonProperty(value="blockGenerationTargetTime")
    public String getBlockGenerationTargetTime() {
        return this.blockGenerationTargetTime;
    }

    public void setBlockGenerationTargetTime(String blockGenerationTargetTime) {
        this.blockGenerationTargetTime = blockGenerationTargetTime;
    }

    public ChainPropertiesDTO blockTimeSmoothingFactor(String blockTimeSmoothingFactor) {
        this.blockTimeSmoothingFactor = blockTimeSmoothingFactor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3000", value="A higher value makes the network more biased.")
    @JsonProperty(value="blockTimeSmoothingFactor")
    public String getBlockTimeSmoothingFactor() {
        return this.blockTimeSmoothingFactor;
    }

    public void setBlockTimeSmoothingFactor(String blockTimeSmoothingFactor) {
        this.blockTimeSmoothingFactor = blockTimeSmoothingFactor;
    }

    public ChainPropertiesDTO importanceGrouping(String importanceGrouping) {
        this.importanceGrouping = importanceGrouping;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="39", value="Number of blocks that should be treated as a group for importance purposes.")
    @JsonProperty(value="importanceGrouping")
    public String getImportanceGrouping() {
        return this.importanceGrouping;
    }

    public void setImportanceGrouping(String importanceGrouping) {
        this.importanceGrouping = importanceGrouping;
    }

    public ChainPropertiesDTO importanceActivityPercentage(String importanceActivityPercentage) {
        this.importanceActivityPercentage = importanceActivityPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="Percentage of importance resulting from fee generation and beneficiary usage.")
    @JsonProperty(value="importanceActivityPercentage")
    public String getImportanceActivityPercentage() {
        return this.importanceActivityPercentage;
    }

    public void setImportanceActivityPercentage(String importanceActivityPercentage) {
        this.importanceActivityPercentage = importanceActivityPercentage;
    }

    public ChainPropertiesDTO maxRollbackBlocks(String maxRollbackBlocks) {
        this.maxRollbackBlocks = maxRollbackBlocks;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="40", value="Maximum number of blocks that can be rolled back.")
    @JsonProperty(value="maxRollbackBlocks")
    public String getMaxRollbackBlocks() {
        return this.maxRollbackBlocks;
    }

    public void setMaxRollbackBlocks(String maxRollbackBlocks) {
        this.maxRollbackBlocks = maxRollbackBlocks;
    }

    public ChainPropertiesDTO maxDifficultyBlocks(String maxDifficultyBlocks) {
        this.maxDifficultyBlocks = maxDifficultyBlocks;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="60", value="Maximum number of blocks to use in a difficulty calculation.")
    @JsonProperty(value="maxDifficultyBlocks")
    public String getMaxDifficultyBlocks() {
        return this.maxDifficultyBlocks;
    }

    public void setMaxDifficultyBlocks(String maxDifficultyBlocks) {
        this.maxDifficultyBlocks = maxDifficultyBlocks;
    }

    public ChainPropertiesDTO defaultDynamicFeeMultiplier(String defaultDynamicFeeMultiplier) {
        this.defaultDynamicFeeMultiplier = defaultDynamicFeeMultiplier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10'000", value="Default multiplier to use for dynamic fees.")
    @JsonProperty(value="defaultDynamicFeeMultiplier")
    public String getDefaultDynamicFeeMultiplier() {
        return this.defaultDynamicFeeMultiplier;
    }

    public void setDefaultDynamicFeeMultiplier(String defaultDynamicFeeMultiplier) {
        this.defaultDynamicFeeMultiplier = defaultDynamicFeeMultiplier;
    }

    public ChainPropertiesDTO maxTransactionLifetime(String maxTransactionLifetime) {
        this.maxTransactionLifetime = maxTransactionLifetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="24h", value="Maximum lifetime a transaction can have before it expires.")
    @JsonProperty(value="maxTransactionLifetime")
    public String getMaxTransactionLifetime() {
        return this.maxTransactionLifetime;
    }

    public void setMaxTransactionLifetime(String maxTransactionLifetime) {
        this.maxTransactionLifetime = maxTransactionLifetime;
    }

    public ChainPropertiesDTO maxBlockFutureTime(String maxBlockFutureTime) {
        this.maxBlockFutureTime = maxBlockFutureTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="500ms", value="Maximum future time of a block that can be accepted.")
    @JsonProperty(value="maxBlockFutureTime")
    public String getMaxBlockFutureTime() {
        return this.maxBlockFutureTime;
    }

    public void setMaxBlockFutureTime(String maxBlockFutureTime) {
        this.maxBlockFutureTime = maxBlockFutureTime;
    }

    public ChainPropertiesDTO initialCurrencyAtomicUnits(String initialCurrencyAtomicUnits) {
        this.initialCurrencyAtomicUnits = initialCurrencyAtomicUnits;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8'998'999'998'000'000", value="Initial currency atomic units available in the network.")
    @JsonProperty(value="initialCurrencyAtomicUnits")
    public String getInitialCurrencyAtomicUnits() {
        return this.initialCurrencyAtomicUnits;
    }

    public void setInitialCurrencyAtomicUnits(String initialCurrencyAtomicUnits) {
        this.initialCurrencyAtomicUnits = initialCurrencyAtomicUnits;
    }

    public ChainPropertiesDTO maxMosaicAtomicUnits(String maxMosaicAtomicUnits) {
        this.maxMosaicAtomicUnits = maxMosaicAtomicUnits;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="9'000'000'000'000'000", value="Maximum atomic units (total-supply * 10 ^ divisibility) of a mosaic allowed in the network.")
    @JsonProperty(value="maxMosaicAtomicUnits")
    public String getMaxMosaicAtomicUnits() {
        return this.maxMosaicAtomicUnits;
    }

    public void setMaxMosaicAtomicUnits(String maxMosaicAtomicUnits) {
        this.maxMosaicAtomicUnits = maxMosaicAtomicUnits;
    }

    public ChainPropertiesDTO totalChainImportance(String totalChainImportance) {
        this.totalChainImportance = totalChainImportance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="15'000'000", value="Total whole importance units available in the network.")
    @JsonProperty(value="totalChainImportance")
    public String getTotalChainImportance() {
        return this.totalChainImportance;
    }

    public void setTotalChainImportance(String totalChainImportance) {
        this.totalChainImportance = totalChainImportance;
    }

    public ChainPropertiesDTO minHarvesterBalance(String minHarvesterBalance) {
        this.minHarvesterBalance = minHarvesterBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="500", value="Minimum number of harvesting mosaic atomic units needed for an account to be eligible for harvesting.")
    @JsonProperty(value="minHarvesterBalance")
    public String getMinHarvesterBalance() {
        return this.minHarvesterBalance;
    }

    public void setMinHarvesterBalance(String minHarvesterBalance) {
        this.minHarvesterBalance = minHarvesterBalance;
    }

    public ChainPropertiesDTO maxHarvesterBalance(String maxHarvesterBalance) {
        this.maxHarvesterBalance = maxHarvesterBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4'000'000", value="Maximum number of harvesting mosaic atomic units needed for an account to be eligible for harvesting.")
    @JsonProperty(value="maxHarvesterBalance")
    public String getMaxHarvesterBalance() {
        return this.maxHarvesterBalance;
    }

    public void setMaxHarvesterBalance(String maxHarvesterBalance) {
        this.maxHarvesterBalance = maxHarvesterBalance;
    }

    public ChainPropertiesDTO harvestBeneficiaryPercentage(String harvestBeneficiaryPercentage) {
        this.harvestBeneficiaryPercentage = harvestBeneficiaryPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Percentage of the harvested fee that is collected by the beneficiary account.")
    @JsonProperty(value="harvestBeneficiaryPercentage")
    public String getHarvestBeneficiaryPercentage() {
        return this.harvestBeneficiaryPercentage;
    }

    public void setHarvestBeneficiaryPercentage(String harvestBeneficiaryPercentage) {
        this.harvestBeneficiaryPercentage = harvestBeneficiaryPercentage;
    }

    public ChainPropertiesDTO blockPruneInterval(String blockPruneInterval) {
        this.blockPruneInterval = blockPruneInterval;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="360", value="Number of blocks between cache pruning.")
    @JsonProperty(value="blockPruneInterval")
    public String getBlockPruneInterval() {
        return this.blockPruneInterval;
    }

    public void setBlockPruneInterval(String blockPruneInterval) {
        this.blockPruneInterval = blockPruneInterval;
    }

    public ChainPropertiesDTO maxTransactionsPerBlock(String maxTransactionsPerBlock) {
        this.maxTransactionsPerBlock = maxTransactionsPerBlock;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="200'000", value="Maximum number of transactions per block.")
    @JsonProperty(value="maxTransactionsPerBlock")
    public String getMaxTransactionsPerBlock() {
        return this.maxTransactionsPerBlock;
    }

    public void setMaxTransactionsPerBlock(String maxTransactionsPerBlock) {
        this.maxTransactionsPerBlock = maxTransactionsPerBlock;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainPropertiesDTO chainPropertiesDTO = (ChainPropertiesDTO)o;
        return Objects.equals(this.enableVerifiableState, chainPropertiesDTO.enableVerifiableState) && Objects.equals(this.enableVerifiableReceipts, chainPropertiesDTO.enableVerifiableReceipts) && Objects.equals(this.currencyMosaicId, chainPropertiesDTO.currencyMosaicId) && Objects.equals(this.harvestingMosaicId, chainPropertiesDTO.harvestingMosaicId) && Objects.equals(this.blockGenerationTargetTime, chainPropertiesDTO.blockGenerationTargetTime) && Objects.equals(this.blockTimeSmoothingFactor, chainPropertiesDTO.blockTimeSmoothingFactor) && Objects.equals(this.importanceGrouping, chainPropertiesDTO.importanceGrouping) && Objects.equals(this.importanceActivityPercentage, chainPropertiesDTO.importanceActivityPercentage) && Objects.equals(this.maxRollbackBlocks, chainPropertiesDTO.maxRollbackBlocks) && Objects.equals(this.maxDifficultyBlocks, chainPropertiesDTO.maxDifficultyBlocks) && Objects.equals(this.defaultDynamicFeeMultiplier, chainPropertiesDTO.defaultDynamicFeeMultiplier) && Objects.equals(this.maxTransactionLifetime, chainPropertiesDTO.maxTransactionLifetime) && Objects.equals(this.maxBlockFutureTime, chainPropertiesDTO.maxBlockFutureTime) && Objects.equals(this.initialCurrencyAtomicUnits, chainPropertiesDTO.initialCurrencyAtomicUnits) && Objects.equals(this.maxMosaicAtomicUnits, chainPropertiesDTO.maxMosaicAtomicUnits) && Objects.equals(this.totalChainImportance, chainPropertiesDTO.totalChainImportance) && Objects.equals(this.minHarvesterBalance, chainPropertiesDTO.minHarvesterBalance) && Objects.equals(this.maxHarvesterBalance, chainPropertiesDTO.maxHarvesterBalance) && Objects.equals(this.harvestBeneficiaryPercentage, chainPropertiesDTO.harvestBeneficiaryPercentage) && Objects.equals(this.blockPruneInterval, chainPropertiesDTO.blockPruneInterval) && Objects.equals(this.maxTransactionsPerBlock, chainPropertiesDTO.maxTransactionsPerBlock);
    }

    public int hashCode() {
        return Objects.hash(this.enableVerifiableState, this.enableVerifiableReceipts, this.currencyMosaicId, this.harvestingMosaicId, this.blockGenerationTargetTime, this.blockTimeSmoothingFactor, this.importanceGrouping, this.importanceActivityPercentage, this.maxRollbackBlocks, this.maxDifficultyBlocks, this.defaultDynamicFeeMultiplier, this.maxTransactionLifetime, this.maxBlockFutureTime, this.initialCurrencyAtomicUnits, this.maxMosaicAtomicUnits, this.totalChainImportance, this.minHarvesterBalance, this.maxHarvesterBalance, this.harvestBeneficiaryPercentage, this.blockPruneInterval, this.maxTransactionsPerBlock);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChainPropertiesDTO {\n");
        sb.append("    enableVerifiableState: ").append(this.toIndentedString(this.enableVerifiableState)).append("\n");
        sb.append("    enableVerifiableReceipts: ").append(this.toIndentedString(this.enableVerifiableReceipts)).append("\n");
        sb.append("    currencyMosaicId: ").append(this.toIndentedString(this.currencyMosaicId)).append("\n");
        sb.append("    harvestingMosaicId: ").append(this.toIndentedString(this.harvestingMosaicId)).append("\n");
        sb.append("    blockGenerationTargetTime: ").append(this.toIndentedString(this.blockGenerationTargetTime)).append("\n");
        sb.append("    blockTimeSmoothingFactor: ").append(this.toIndentedString(this.blockTimeSmoothingFactor)).append("\n");
        sb.append("    importanceGrouping: ").append(this.toIndentedString(this.importanceGrouping)).append("\n");
        sb.append("    importanceActivityPercentage: ").append(this.toIndentedString(this.importanceActivityPercentage)).append("\n");
        sb.append("    maxRollbackBlocks: ").append(this.toIndentedString(this.maxRollbackBlocks)).append("\n");
        sb.append("    maxDifficultyBlocks: ").append(this.toIndentedString(this.maxDifficultyBlocks)).append("\n");
        sb.append("    defaultDynamicFeeMultiplier: ").append(this.toIndentedString(this.defaultDynamicFeeMultiplier)).append("\n");
        sb.append("    maxTransactionLifetime: ").append(this.toIndentedString(this.maxTransactionLifetime)).append("\n");
        sb.append("    maxBlockFutureTime: ").append(this.toIndentedString(this.maxBlockFutureTime)).append("\n");
        sb.append("    initialCurrencyAtomicUnits: ").append(this.toIndentedString(this.initialCurrencyAtomicUnits)).append("\n");
        sb.append("    maxMosaicAtomicUnits: ").append(this.toIndentedString(this.maxMosaicAtomicUnits)).append("\n");
        sb.append("    totalChainImportance: ").append(this.toIndentedString(this.totalChainImportance)).append("\n");
        sb.append("    minHarvesterBalance: ").append(this.toIndentedString(this.minHarvesterBalance)).append("\n");
        sb.append("    maxHarvesterBalance: ").append(this.toIndentedString(this.maxHarvesterBalance)).append("\n");
        sb.append("    harvestBeneficiaryPercentage: ").append(this.toIndentedString(this.harvestBeneficiaryPercentage)).append("\n");
        sb.append("    blockPruneInterval: ").append(this.toIndentedString(this.blockPruneInterval)).append("\n");
        sb.append("    maxTransactionsPerBlock: ").append(this.toIndentedString(this.maxTransactionsPerBlock)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

