/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.22
 *
 * The version of the OpenAPI document: 0.8.7
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.jersey2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.jersey2.model.InflationReceiptDTOAllOf;
import io.nem.symbol.sdk.openapi.jersey2.model.ReceiptDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.ReceiptTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Receipt stored when network currency mosaics were created due to inflation.
 */
@ApiModel(description = "Receipt stored when network currency mosaics were created due to inflation.")
@JsonPropertyOrder({
  InflationReceiptDTO.JSON_PROPERTY_VERSION,
  InflationReceiptDTO.JSON_PROPERTY_TYPE,
  InflationReceiptDTO.JSON_PROPERTY_MOSAIC_ID,
  InflationReceiptDTO.JSON_PROPERTY_AMOUNT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-11T19:39:58.143-03:00[America/Argentina/Buenos_Aires]")
public class InflationReceiptDTO {
  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_TYPE = "type";
  private ReceiptTypeEnum type;

  public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
  private String mosaicId;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private java.math.BigInteger amount = null;


  public InflationReceiptDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version of the receipt.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Version of the receipt.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public InflationReceiptDTO type(ReceiptTypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ReceiptTypeEnum getType() {
    return type;
  }


  public void setType(ReceiptTypeEnum type) {
    this.type = type;
  }


  public InflationReceiptDTO mosaicId(String mosaicId) {
    
    this.mosaicId = mosaicId;
    return this;
  }

   /**
   * Mosaic identifier.
   * @return mosaicId
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Mosaic identifier.")
  @JsonProperty(JSON_PROPERTY_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMosaicId() {
    return mosaicId;
  }


  public void setMosaicId(String mosaicId) {
    this.mosaicId = mosaicId;
  }


  public InflationReceiptDTO amount(java.math.BigInteger amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return amount
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getAmount() {
    return amount;
  }


  public void setAmount(java.math.BigInteger amount) {
    this.amount = amount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InflationReceiptDTO inflationReceiptDTO = (InflationReceiptDTO) o;
    return Objects.equals(this.version, inflationReceiptDTO.version) &&
        Objects.equals(this.type, inflationReceiptDTO.type) &&
        Objects.equals(this.mosaicId, inflationReceiptDTO.mosaicId) &&
        Objects.equals(this.amount, inflationReceiptDTO.amount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, type, mosaicId, amount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InflationReceiptDTO {\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    mosaicId: ").append(toIndentedString(mosaicId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

