/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.22
 *
 * The version of the OpenAPI document: 0.8.7
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.jersey2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.jersey2.model.BlockDTOAllOf;
import io.nem.symbol.sdk.openapi.jersey2.model.EntityDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.VerifiableEntityDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * BlockDTO
 */
@JsonPropertyOrder({
  BlockDTO.JSON_PROPERTY_SIGNATURE,
  BlockDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  BlockDTO.JSON_PROPERTY_VERSION,
  BlockDTO.JSON_PROPERTY_NETWORK,
  BlockDTO.JSON_PROPERTY_TYPE,
  BlockDTO.JSON_PROPERTY_HEIGHT,
  BlockDTO.JSON_PROPERTY_TIMESTAMP,
  BlockDTO.JSON_PROPERTY_DIFFICULTY,
  BlockDTO.JSON_PROPERTY_PREVIOUS_BLOCK_HASH,
  BlockDTO.JSON_PROPERTY_TRANSACTIONS_HASH,
  BlockDTO.JSON_PROPERTY_RECEIPTS_HASH,
  BlockDTO.JSON_PROPERTY_STATE_HASH,
  BlockDTO.JSON_PROPERTY_BENEFICIARY_PUBLIC_KEY,
  BlockDTO.JSON_PROPERTY_FEE_MULTIPLIER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-11T19:39:58.143-03:00[America/Argentina/Buenos_Aires]")
public class BlockDTO {
  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private java.math.BigInteger height = null;

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private java.math.BigInteger timestamp = null;

  public static final String JSON_PROPERTY_DIFFICULTY = "difficulty";
  private java.math.BigInteger difficulty = null;

  public static final String JSON_PROPERTY_PREVIOUS_BLOCK_HASH = "previousBlockHash";
  private String previousBlockHash;

  public static final String JSON_PROPERTY_TRANSACTIONS_HASH = "transactionsHash";
  private String transactionsHash;

  public static final String JSON_PROPERTY_RECEIPTS_HASH = "receiptsHash";
  private String receiptsHash;

  public static final String JSON_PROPERTY_STATE_HASH = "stateHash";
  private String stateHash;

  public static final String JSON_PROPERTY_BENEFICIARY_PUBLIC_KEY = "beneficiaryPublicKey";
  private String beneficiaryPublicKey;

  public static final String JSON_PROPERTY_FEE_MULTIPLIER = "feeMultiplier";
  private Integer feeMultiplier;


  public BlockDTO signature(String signature) {
    
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignature() {
    return signature;
  }


  public void setSignature(String signature) {
    this.signature = signature;
  }


  public BlockDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public BlockDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public BlockDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public BlockDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public BlockDTO height(java.math.BigInteger height) {
    
    this.height = height;
    return this;
  }

   /**
   * Height of the blockchain.
   * @return height
  **/
  @ApiModelProperty(example = "1", required = true, value = "Height of the blockchain.")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getHeight() {
    return height;
  }


  public void setHeight(java.math.BigInteger height) {
    this.height = height;
  }


  public BlockDTO timestamp(java.math.BigInteger timestamp) {
    
    this.timestamp = timestamp;
    return this;
  }

   /**
   * Number of seconds elapsed since the creation of the nemesis block.
   * @return timestamp
  **/
  @ApiModelProperty(example = "108303181802", required = true, value = "Number of seconds elapsed since the creation of the nemesis block.")
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getTimestamp() {
    return timestamp;
  }


  public void setTimestamp(java.math.BigInteger timestamp) {
    this.timestamp = timestamp;
  }


  public BlockDTO difficulty(java.math.BigInteger difficulty) {
    
    this.difficulty = difficulty;
    return this;
  }

   /**
   * Determines how hard is to harvest a new block, based on previous blocks.
   * @return difficulty
  **/
  @ApiModelProperty(example = "100000000000000", required = true, value = "Determines how hard is to harvest a new block, based on previous blocks.")
  @JsonProperty(JSON_PROPERTY_DIFFICULTY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getDifficulty() {
    return difficulty;
  }


  public void setDifficulty(java.math.BigInteger difficulty) {
    this.difficulty = difficulty;
  }


  public BlockDTO previousBlockHash(String previousBlockHash) {
    
    this.previousBlockHash = previousBlockHash;
    return this;
  }

   /**
   * Get previousBlockHash
   * @return previousBlockHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PREVIOUS_BLOCK_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPreviousBlockHash() {
    return previousBlockHash;
  }


  public void setPreviousBlockHash(String previousBlockHash) {
    this.previousBlockHash = previousBlockHash;
  }


  public BlockDTO transactionsHash(String transactionsHash) {
    
    this.transactionsHash = transactionsHash;
    return this;
  }

   /**
   * Get transactionsHash
   * @return transactionsHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TRANSACTIONS_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTransactionsHash() {
    return transactionsHash;
  }


  public void setTransactionsHash(String transactionsHash) {
    this.transactionsHash = transactionsHash;
  }


  public BlockDTO receiptsHash(String receiptsHash) {
    
    this.receiptsHash = receiptsHash;
    return this;
  }

   /**
   * Get receiptsHash
   * @return receiptsHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_RECEIPTS_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getReceiptsHash() {
    return receiptsHash;
  }


  public void setReceiptsHash(String receiptsHash) {
    this.receiptsHash = receiptsHash;
  }


  public BlockDTO stateHash(String stateHash) {
    
    this.stateHash = stateHash;
    return this;
  }

   /**
   * Get stateHash
   * @return stateHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_STATE_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStateHash() {
    return stateHash;
  }


  public void setStateHash(String stateHash) {
    this.stateHash = stateHash;
  }


  public BlockDTO beneficiaryPublicKey(String beneficiaryPublicKey) {
    
    this.beneficiaryPublicKey = beneficiaryPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return beneficiaryPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_BENEFICIARY_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBeneficiaryPublicKey() {
    return beneficiaryPublicKey;
  }


  public void setBeneficiaryPublicKey(String beneficiaryPublicKey) {
    this.beneficiaryPublicKey = beneficiaryPublicKey;
  }


  public BlockDTO feeMultiplier(Integer feeMultiplier) {
    
    this.feeMultiplier = feeMultiplier;
    return this;
  }

   /**
   * Fee multiplier applied to transactions contained in block.
   * @return feeMultiplier
  **/
  @ApiModelProperty(example = "0", required = true, value = "Fee multiplier applied to transactions contained in block.")
  @JsonProperty(JSON_PROPERTY_FEE_MULTIPLIER)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getFeeMultiplier() {
    return feeMultiplier;
  }


  public void setFeeMultiplier(Integer feeMultiplier) {
    this.feeMultiplier = feeMultiplier;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BlockDTO blockDTO = (BlockDTO) o;
    return Objects.equals(this.signature, blockDTO.signature) &&
        Objects.equals(this.signerPublicKey, blockDTO.signerPublicKey) &&
        Objects.equals(this.version, blockDTO.version) &&
        Objects.equals(this.network, blockDTO.network) &&
        Objects.equals(this.type, blockDTO.type) &&
        Objects.equals(this.height, blockDTO.height) &&
        Objects.equals(this.timestamp, blockDTO.timestamp) &&
        Objects.equals(this.difficulty, blockDTO.difficulty) &&
        Objects.equals(this.previousBlockHash, blockDTO.previousBlockHash) &&
        Objects.equals(this.transactionsHash, blockDTO.transactionsHash) &&
        Objects.equals(this.receiptsHash, blockDTO.receiptsHash) &&
        Objects.equals(this.stateHash, blockDTO.stateHash) &&
        Objects.equals(this.beneficiaryPublicKey, blockDTO.beneficiaryPublicKey) &&
        Objects.equals(this.feeMultiplier, blockDTO.feeMultiplier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signature, signerPublicKey, version, network, type, height, timestamp, difficulty, previousBlockHash, transactionsHash, receiptsHash, stateHash, beneficiaryPublicKey, feeMultiplier);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BlockDTO {\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    difficulty: ").append(toIndentedString(difficulty)).append("\n");
    sb.append("    previousBlockHash: ").append(toIndentedString(previousBlockHash)).append("\n");
    sb.append("    transactionsHash: ").append(toIndentedString(transactionsHash)).append("\n");
    sb.append("    receiptsHash: ").append(toIndentedString(receiptsHash)).append("\n");
    sb.append("    stateHash: ").append(toIndentedString(stateHash)).append("\n");
    sb.append("    beneficiaryPublicKey: ").append(toIndentedString(beneficiaryPublicKey)).append("\n");
    sb.append("    feeMultiplier: ").append(toIndentedString(feeMultiplier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

