/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.22
 *
 * The version of the OpenAPI document: 0.8.7
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.jersey2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Supplementary data stored for importance recalculation. At each importance recalculation, existing buckets are shifted, the working bucket is finalized and a new working bucketis created. Each bucket influences at most five importance recalculations. 
 */
@ApiModel(description = "Supplementary data stored for importance recalculation. At each importance recalculation, existing buckets are shifted, the working bucket is finalized and a new working bucketis created. Each bucket influences at most five importance recalculations. ")
@JsonPropertyOrder({
  ActivityBucketDTO.JSON_PROPERTY_START_HEIGHT,
  ActivityBucketDTO.JSON_PROPERTY_TOTAL_FEES_PAID,
  ActivityBucketDTO.JSON_PROPERTY_BENEFICIARY_COUNT,
  ActivityBucketDTO.JSON_PROPERTY_RAW_SCORE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-11T19:39:58.143-03:00[America/Argentina/Buenos_Aires]")
public class ActivityBucketDTO {
  public static final String JSON_PROPERTY_START_HEIGHT = "startHeight";
  private java.math.BigInteger startHeight = null;

  public static final String JSON_PROPERTY_TOTAL_FEES_PAID = "totalFeesPaid";
  private Integer totalFeesPaid;

  public static final String JSON_PROPERTY_BENEFICIARY_COUNT = "beneficiaryCount";
  private Integer beneficiaryCount;

  public static final String JSON_PROPERTY_RAW_SCORE = "rawScore";
  private Integer rawScore;


  public ActivityBucketDTO startHeight(java.math.BigInteger startHeight) {
    
    this.startHeight = startHeight;
    return this;
  }

   /**
   * Height of the blockchain.
   * @return startHeight
  **/
  @ApiModelProperty(example = "1", required = true, value = "Height of the blockchain.")
  @JsonProperty(JSON_PROPERTY_START_HEIGHT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getStartHeight() {
    return startHeight;
  }


  public void setStartHeight(java.math.BigInteger startHeight) {
    this.startHeight = startHeight;
  }


  public ActivityBucketDTO totalFeesPaid(Integer totalFeesPaid) {
    
    this.totalFeesPaid = totalFeesPaid;
    return this;
  }

   /**
   * Fees paid by the account for this bucket.
   * @return totalFeesPaid
  **/
  @ApiModelProperty(required = true, value = "Fees paid by the account for this bucket.")
  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_PAID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getTotalFeesPaid() {
    return totalFeesPaid;
  }


  public void setTotalFeesPaid(Integer totalFeesPaid) {
    this.totalFeesPaid = totalFeesPaid;
  }


  public ActivityBucketDTO beneficiaryCount(Integer beneficiaryCount) {
    
    this.beneficiaryCount = beneficiaryCount;
    return this;
  }

   /**
   * Number of times the account has been a beneficiary for this bucket.
   * @return beneficiaryCount
  **/
  @ApiModelProperty(required = true, value = "Number of times the account has been a beneficiary for this bucket.")
  @JsonProperty(JSON_PROPERTY_BENEFICIARY_COUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getBeneficiaryCount() {
    return beneficiaryCount;
  }


  public void setBeneficiaryCount(Integer beneficiaryCount) {
    this.beneficiaryCount = beneficiaryCount;
  }


  public ActivityBucketDTO rawScore(Integer rawScore) {
    
    this.rawScore = rawScore;
    return this;
  }

   /**
   * Importance score for this bucket. This is taken into account to calculate the latest account importance.
   * @return rawScore
  **/
  @ApiModelProperty(required = true, value = "Importance score for this bucket. This is taken into account to calculate the latest account importance.")
  @JsonProperty(JSON_PROPERTY_RAW_SCORE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getRawScore() {
    return rawScore;
  }


  public void setRawScore(Integer rawScore) {
    this.rawScore = rawScore;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActivityBucketDTO activityBucketDTO = (ActivityBucketDTO) o;
    return Objects.equals(this.startHeight, activityBucketDTO.startHeight) &&
        Objects.equals(this.totalFeesPaid, activityBucketDTO.totalFeesPaid) &&
        Objects.equals(this.beneficiaryCount, activityBucketDTO.beneficiaryCount) &&
        Objects.equals(this.rawScore, activityBucketDTO.rawScore);
  }

  @Override
  public int hashCode() {
    return Objects.hash(startHeight, totalFeesPaid, beneficiaryCount, rawScore);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActivityBucketDTO {\n");
    sb.append("    startHeight: ").append(toIndentedString(startHeight)).append("\n");
    sb.append("    totalFeesPaid: ").append(toIndentedString(totalFeesPaid)).append("\n");
    sb.append("    beneficiaryCount: ").append(toIndentedString(beneficiaryCount)).append("\n");
    sb.append("    rawScore: ").append(toIndentedString(rawScore)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

