/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.20
 *
 * The version of the OpenAPI document: 0.8.6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.jersey2.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Status of the transaction: * Success - * Neutral - * Failure - * Failure_Core_Past_Deadline - Validation failed because the deadline passed. * Failure_Core_Future_Deadline - Validation failed because the deadline is too far in the future. * Failure_Core_Insufficient_Balance - Validation failed because the account has an insufficient balance. * Failure_Core_Too_Many_Transactions - Validation failed because there are too many transactions in a block. * Failure_Core_Nemesis_Account_Signed_After_Nemesis_Block - Validation failed because an entity originated from the nemesis account after the nemesis block. * Failure_Core_Wrong_Network - Validation failed because the entity has the wrong network specified. * Failure_Core_Invalid_Address - Validation failed because an address is invalid. * Failure_Core_Invalid_Version - Validation failed because entity version is invalid. * Failure_Core_Invalid_Transaction_Fee - Validation failed because a transaction fee is invalid. * Failure_Core_Block_Harvester_Ineligible - Validation failed because a block was harvested by an ineligible harvester. * Failure_Core_Zero_Address - Validation failed because an address is zero. * Failure_Core_Zero_Public_Key - Validation failed because a public key is zero. * Failure_Core_Nonzero_Internal_Padding - Validation failed because internal padding is nonzero. * Failure_Hash_Already_Exists - * Failure_Signature_Not_Verifiable - Validation failed because the verification of the signature failed. * Failure_AccountLink_Invalid_Action - Validation failed because account link action is invalid. * Failure_AccountLink_Link_Already_Exists - Validation failed because main account is already linked to another account. * Failure_AccountLink_Unknown_Link - Validation failed because main account is not linked to another account. * Failure_AccountLink_Inconsistent_Unlink_Data - Validation failed because unlink data is not consistent with existing account link. * Failure_AccountLink_Remote_Account_Ineligible - Validation failed because link is attempting to convert ineligible account to remote. * Failure_AccountLink_Remote_Account_Signer_Prohibited - Validation failed because remote is not allowed to sign a transaction. * Failure_AccountLink_Remote_Account_Participant_Prohibited - Validation failed because remote is not allowed to participate in the transaction. * Failure_Aggregate_Too_Many_Transactions - Validation failed because aggregate has too many transactions. * Failure_Aggregate_No_Transactions - Validation failed because aggregate does not have any transactions. * Failure_Aggregate_Too_Many_Cosignatures - Validation failed because aggregate has too many cosignatures. * Failure_Aggregate_Redundant_Cosignatures - Validation failed because redundant cosignatures are present. * Failure_Aggregate_Ineligible_Cosignatories - Validation failed because at least one cosignatory is ineligible. * Failure_Aggregate_Missing_Cosignatures - Validation failed because at least one required cosignature is missing. * Failure_Aggregate_Transactions_Hash_Mismatch - Validation failed because the aggregate transactions hash does not match the calculated value. * Failure_LockHash_Invalid_Mosaic_Id - Validation failed because lock does not allow the specified mosaic. * Failure_LockHash_Invalid_Mosaic_Amount - Validation failed because lock does not allow the specified amount. * Failure_LockHash_Hash_Already_Exists - Validation failed because hash is already present in cache. * Failure_LockHash_Unknown_Hash - Validation failed because hash is not present in cache. * Failure_LockHash_Inactive_Hash - Validation failed because hash is inactive. * Failure_LockHash_Invalid_Duration - Validation failed because duration is too long. * Failure_LockSecret_Invalid_Hash_Algorithm - Validation failed because hash algorithm for lock type secret is invalid. * Failure_LockSecret_Hash_Already_Exists - Validation failed because hash is already present in cache. * Failure_LockSecret_Proof_Size_Out_Of_Bounds - Validation failed because proof is too small or too large. * Failure_LockSecret_Secret_Mismatch - Validation failed because secret does not match proof. * Failure_LockSecret_Unknown_Composite_Key - Validation failed because composite key is unknown. * Failure_LockSecret_Inactive_Secret - Validation failed because secret is inactive. * Failure_LockSecret_Hash_Algorithm_Mismatch - Validation failed because hash algorithm does not match. * Failure_LockSecret_Invalid_Duration - Validation failed because duration is too long. * Failure_Metadata_Value_Too_Small - Validation failed because the metadata value is too small. * Failure_Metadata_Value_Too_Large - Validation failed because the metadata value is too large. * Failure_Metadata_Value_Size_Delta_Too_Large - Validation failed because the metadata value size delta is larger in magnitude than the value size. * Failure_Metadata_Value_Size_Delta_Mismatch - Validation failed because the metadata value size delta does not match expected value based on the current state. * Failure_Metadata_Value_Change_Irreversible - Validation failed because a metadata value change (truncation) is irreversible. * Failure_Mosaic_Invalid_Duration - Validation failed because the duration has an invalid value. * Failure_Mosaic_Invalid_Name - Validation failed because the name is invalid. * Failure_Mosaic_Name_Id_Mismatch - Validation failed because the name and id don&#39;t match. * Failure_Mosaic_Expired - Validation failed because the parent is expired. * Failure_Mosaic_Owner_Conflict - Validation failed because the parent owner conflicts with the child owner. * Failure_Mosaic_Id_Mismatch - Validation failed because the id is not the expected id generated from signer and nonce. * Failure_Mosaic_Parent_Id_Conflict - Validation failed because the existing parent id does not match the supplied parent id. * Failure_Mosaic_Invalid_Property - Validation failed because a mosaic property is invalid. * Failure_Mosaic_Invalid_Flags - Validation failed because the mosaic flags are invalid. * Failure_Mosaic_Invalid_Divisibility - Validation failed because the mosaic divisibility is invalid. * Failure_Mosaic_Invalid_Supply_Change_Action - Validation failed because the mosaic supply change action is invalid. * Failure_Mosaic_Invalid_Supply_Change_Amount - Validation failed because the mosaic supply change amount is invalid. * Failure_Mosaic_Invalid_Id - Validation failed because the mosaic id is invalid. * Failure_Mosaic_Modification_Disallowed - Validation failed because mosaic modification is not allowed. * Failure_Mosaic_Modification_No_Changes - Validation failed because mosaic modification would not result in any changes. * Failure_Mosaic_Supply_Immutable - Validation failed because the mosaic supply is immutable. * Failure_Mosaic_Supply_Negative - Validation failed because the resulting mosaic supply is negative. * Failure_Mosaic_Supply_Exceeded - Validation failed because the resulting mosaic supply exceeds the maximum allowed value. * Failure_Mosaic_Non_Transferable - Validation failed because the mosaic is not transferable. * Failure_Mosaic_Max_Mosaics_Exceeded - Validation failed because the credit of the mosaic would exceed the maximum of different mosaics an account is allowed to own. * Failure_Mosaic_Required_Property_Flag_Unset - Validation failed because the mosaic has at least one required property flag unset. * Failure_Multisig_Account_In_Both_Sets - Validation failed because account is specified to be both added and removed. * Failure_Multisig_Multiple_Deletes - Validation failed because multiple removals are present. * Failure_Multisig_Redundant_Modification - Validation failed because a modification is redundant. * Failure_Multisig_Unknown_Multisig_Account - Validation failed because account is not in multisig cache. * Failure_Multisig_Not_A_Cosignatory - Validation failed because account to be removed is not present. * Failure_Multisig_Already_A_Cosignatory - Validation failed because account to be added is already a cosignatory. * Failure_Multisig_Min_Setting_Out_Of_Range - Validation failed because new minimum settings are out of range. * Failure_Multisig_Min_Setting_Larger_Than_Num_Cosignatories - Validation failed because min settings are larger than number of cosignatories. * Failure_Multisig_Invalid_Modification_Action - Validation failed because the modification action is invalid. * Failure_Multisig_Max_Cosigned_Accounts - Validation failed because the cosignatory already cosigns the maximum number of accounts. * Failure_Multisig_Max_Cosignatories - Validation failed because the multisig account already has the maximum number of cosignatories. * Failure_Multisig_Loop - Validation failed because a multisig loop is created. * Failure_Multisig_Max_Multisig_Depth - Validation failed because the max multisig depth is exceeded. * Failure_Multisig_Operation_Prohibited_By_Account - Validation failed because an operation is not permitted by a multisig account. * Failure_Namespace_Invalid_Duration - Validation failed because the duration has an invalid value. * Failure_Namespace_Invalid_Name - Validation failed because the name is invalid. * Failure_Namespace_Name_Id_Mismatch - Validation failed because the name and id don&#39;t match. * Failure_Namespace_Expired - Validation failed because the parent is expired. * Failure_Namespace_Owner_Conflict - Validation failed because the parent owner conflicts with the child owner. * Failure_Namespace_Id_Mismatch - Validation failed because the id is not the expected id generated from signer and nonce. * Failure_Namespace_Invalid_Registration_Type - Validation failed because the namespace registration type is invalid. * Failure_Namespace_Root_Name_Reserved - Validation failed because the root namespace has a reserved name. * Failure_Namespace_Too_Deep - Validation failed because the resulting namespace would exceed the maximum allowed namespace depth. * Failure_Namespace_Unknown_Parent - Validation failed because the namespace parent is unknown. * Failure_Namespace_Already_Exists - Validation failed because the namespace already exists. * Failure_Namespace_Already_Active - Validation failed because the namespace is already active. * Failure_Namespace_Eternal_After_Nemesis_Block - Validation failed because an eternal namespace was received after the nemesis block. * Failure_Namespace_Max_Children_Exceeded - Validation failed because the maximum number of children for a root namespace was exceeded. * Failure_Namespace_Alias_Invalid_Action - Validation failed because alias action is invalid. * Failure_Namespace_Unknown - Validation failed because namespace does not exist. * Failure_Namespace_Alias_Already_Exists - Validation failed because namespace is already linked to an alias. * Failure_Namespace_Unknown_Alias - Validation failed because namespace is not linked to an alias. * Failure_Namespace_Alias_Inconsistent_Unlink_Type - Validation failed because unlink type is not consistent with existing alias. * Failure_Namespace_Alias_Inconsistent_Unlink_Data - Validation failed because unlink data is not consistent with existing alias. * Failure_Namespace_Alias_Invalid_Address - Validation failed because aliased address is invalid. * Failure_RestrictionAccount_Invalid_Restriction_Flags - Validation failed because the account restriction flags are invalid. * Failure_RestrictionAccount_Invalid_Modification_Action - Validation failed because a modification action is invalid. * Failure_RestrictionAccount_Invalid_Modification_Address - Validation failed because a modification address is invalid. * Failure_RestrictionAccount_Modification_Operation_Type_Incompatible - Validation failed because the operation type is incompatible. *Note*: This indicates that the existing restrictions have a different operation type than that specified in the notification. * Failure_RestrictionAccount_Redundant_Modification - Validation failed because a modification is redundant. * Failure_RestrictionAccount_Invalid_Modification - Validation failed because a value is not in the container. * Failure_RestrictionAccount_Modification_Count_Exceeded - Validation failed because the transaction has too many modifications. * Failure_RestrictionAccount_No_Modifications - Validation failed because the transaction has no modifications. * Failure_RestrictionAccount_Values_Count_Exceeded - Validation failed because the resulting account restriction has too many values. * Failure_RestrictionAccount_Invalid_Value - Validation failed because the account restriction value is invalid. * Failure_RestrictionAccount_Address_Interaction_Prohibited - Validation failed because the addresses involved in the transaction are not allowed to interact. * Failure_RestrictionAccount_Mosaic_Transfer_Prohibited - Validation failed because the mosaic transfer is prohibited by the recipient. * Failure_RestrictionAccount_Operation_Type_Prohibited - Validation failed because the operation type is not allowed to be initiated by the signer. * Failure_RestrictionMosaic_Invalid_Restriction_Type - Validation failed because the mosaic restriction type is invalid. * Failure_RestrictionMosaic_Previous_Value_Mismatch - Validation failed because specified previous value does not match current value. * Failure_RestrictionMosaic_Previous_Value_Must_Be_Zero - Validation failed because specified previous value is nonzero. * Failure_RestrictionMosaic_Max_Restrictions_Exceeded - Validation failed because the maximum number of restrictions would be exeeded. * Failure_RestrictionMosaic_Cannot_Delete_Nonexistent_Restriction - Validation failed because nonexistent restriction cannot be deleted. * Failure_RestrictionMosaic_Unknown_Global_Restriction - Validation failed because required global restriction does not exist. * Failure_RestrictionMosaic_Invalid_Global_Restriction - Validation failed because mosaic has invalid global restriction. * Failure_RestrictionMosaic_Account_Unauthorized - Validation failed because account lacks proper permissions to move mosaic. * Failure_Transfer_Message_Too_Large - Validation failed because the message is too large. * Failure_Transfer_Out_Of_Order_Mosaics - Validation failed because mosaics are out of order. * Failure_Chain_Unlinked - Validation failed because a block was received that did not link with the existing chain. * Failure_Chain_Block_Not_Hit - Validation failed because a block was received that is not a hit. * Failure_Chain_Block_Inconsistent_State_Hash - Validation failed because a block was received that has an inconsistent state hash. * Failure_Chain_Block_Inconsistent_Receipts_Hash - Validation failed because a block was received that has an inconsistent receipts hash. * Failure_Chain_Unconfirmed_Cache_Too_Full - Validation failed because the unconfirmed cache is too full. * Failure_Consumer_Empty_Input - Validation failed because the consumer input is empty. * Failure_Consumer_Block_Transactions_Hash_Mismatch - Validation failed because the block transactions hash does not match the calculated value. * Neutral_Consumer_Hash_In_Recency_Cache - Validation failed because an entity hash is present in the recency cache. * Failure_Consumer_Remote_Chain_Too_Many_Blocks - Validation failed because the chain part has too many blocks. * Failure_Consumer_Remote_Chain_Improper_Link - Validation failed because the chain is internally improperly linked. * Failure_Consumer_Remote_Chain_Duplicate_Transactions - Validation failed because the chain part contains duplicate transactions. * Failure_Consumer_Remote_Chain_Unlinked - Validation failed because the chain part does not link to the current chain. * Failure_Consumer_Remote_Chain_Difficulties_Mismatch - Validation failed because the remote chain difficulties do not match the calculated difficulties. * Failure_Consumer_Remote_Chain_Score_Not_Better - Validation failed because the remote chain score is not better. * Failure_Consumer_Remote_Chain_Too_Far_Behind - Validation failed because the remote chain is too far behind. * Failure_Consumer_Remote_Chain_Too_Far_In_Future - Validation failed because the remote chain timestamp is too far in the future. * Failure_Consumer_Batch_Signature_Not_Verifiable - Validation failed because the verification of the signature failed during a batch operation. * Failure_Extension_Partial_Transaction_Cache_Prune - Validation failed because the partial transaction was pruned from the temporal cache. * Failure_Extension_Partial_Transaction_Dependency_Removed - Validation failed because the partial transaction was pruned from the temporal cache due to its dependency being removed. * Failure_Extension_Read_Rate_Limit_Exceeded - Validation failed because socket read rate limit was exceeded. 
 */
public enum TransactionStatusTypeEnum {
  
  SUCCESS("Success"),
  
  NEUTRAL("Neutral"),
  
  FAILURE("Failure"),
  
  FAILURE_CORE_PAST_DEADLINE("Failure_Core_Past_Deadline"),
  
  FAILURE_CORE_FUTURE_DEADLINE("Failure_Core_Future_Deadline"),
  
  FAILURE_CORE_INSUFFICIENT_BALANCE("Failure_Core_Insufficient_Balance"),
  
  FAILURE_CORE_TOO_MANY_TRANSACTIONS("Failure_Core_Too_Many_Transactions"),
  
  FAILURE_CORE_NEMESIS_ACCOUNT_SIGNED_AFTER_NEMESIS_BLOCK("Failure_Core_Nemesis_Account_Signed_After_Nemesis_Block"),
  
  FAILURE_CORE_WRONG_NETWORK("Failure_Core_Wrong_Network"),
  
  FAILURE_CORE_INVALID_ADDRESS("Failure_Core_Invalid_Address"),
  
  FAILURE_CORE_INVALID_VERSION("Failure_Core_Invalid_Version"),
  
  FAILURE_CORE_INVALID_TRANSACTION_FEE("Failure_Core_Invalid_Transaction_Fee"),
  
  FAILURE_CORE_BLOCK_HARVESTER_INELIGIBLE("Failure_Core_Block_Harvester_Ineligible"),
  
  FAILURE_CORE_ZERO_ADDRESS("Failure_Core_Zero_Address"),
  
  FAILURE_CORE_ZERO_PUBLIC_KEY("Failure_Core_Zero_Public_Key"),
  
  FAILURE_CORE_NONZERO_INTERNAL_PADDING("Failure_Core_Nonzero_Internal_Padding"),
  
  FAILURE_HASH_ALREADY_EXISTS("Failure_Hash_Already_Exists"),
  
  FAILURE_SIGNATURE_NOT_VERIFIABLE("Failure_Signature_Not_Verifiable"),
  
  FAILURE_ACCOUNTLINK_INVALID_ACTION("Failure_AccountLink_Invalid_Action"),
  
  FAILURE_ACCOUNTLINK_LINK_ALREADY_EXISTS("Failure_AccountLink_Link_Already_Exists"),
  
  FAILURE_ACCOUNTLINK_UNKNOWN_LINK("Failure_AccountLink_Unknown_Link"),
  
  FAILURE_ACCOUNTLINK_INCONSISTENT_UNLINK_DATA("Failure_AccountLink_Inconsistent_Unlink_Data"),
  
  FAILURE_ACCOUNTLINK_REMOTE_ACCOUNT_INELIGIBLE("Failure_AccountLink_Remote_Account_Ineligible"),
  
  FAILURE_ACCOUNTLINK_REMOTE_ACCOUNT_SIGNER_PROHIBITED("Failure_AccountLink_Remote_Account_Signer_Prohibited"),
  
  FAILURE_ACCOUNTLINK_REMOTE_ACCOUNT_PARTICIPANT_PROHIBITED("Failure_AccountLink_Remote_Account_Participant_Prohibited"),
  
  FAILURE_AGGREGATE_TOO_MANY_TRANSACTIONS("Failure_Aggregate_Too_Many_Transactions"),
  
  FAILURE_AGGREGATE_NO_TRANSACTIONS("Failure_Aggregate_No_Transactions"),
  
  FAILURE_AGGREGATE_TOO_MANY_COSIGNATURES("Failure_Aggregate_Too_Many_Cosignatures"),
  
  FAILURE_AGGREGATE_REDUNDANT_COSIGNATURES("Failure_Aggregate_Redundant_Cosignatures"),
  
  FAILURE_AGGREGATE_INELIGIBLE_COSIGNATORIES("Failure_Aggregate_Ineligible_Cosignatories"),
  
  FAILURE_AGGREGATE_MISSING_COSIGNATURES("Failure_Aggregate_Missing_Cosignatures"),
  
  FAILURE_AGGREGATE_TRANSACTIONS_HASH_MISMATCH("Failure_Aggregate_Transactions_Hash_Mismatch"),
  
  FAILURE_LOCKHASH_INVALID_MOSAIC_ID("Failure_LockHash_Invalid_Mosaic_Id"),
  
  FAILURE_LOCKHASH_INVALID_MOSAIC_AMOUNT("Failure_LockHash_Invalid_Mosaic_Amount"),
  
  FAILURE_LOCKHASH_HASH_ALREADY_EXISTS("Failure_LockHash_Hash_Already_Exists"),
  
  FAILURE_LOCKHASH_UNKNOWN_HASH("Failure_LockHash_Unknown_Hash"),
  
  FAILURE_LOCKHASH_INACTIVE_HASH("Failure_LockHash_Inactive_Hash"),
  
  FAILURE_LOCKHASH_INVALID_DURATION("Failure_LockHash_Invalid_Duration"),
  
  FAILURE_LOCKSECRET_INVALID_HASH_ALGORITHM("Failure_LockSecret_Invalid_Hash_Algorithm"),
  
  FAILURE_LOCKSECRET_HASH_ALREADY_EXISTS("Failure_LockSecret_Hash_Already_Exists"),
  
  FAILURE_LOCKSECRET_PROOF_SIZE_OUT_OF_BOUNDS("Failure_LockSecret_Proof_Size_Out_Of_Bounds"),
  
  FAILURE_LOCKSECRET_SECRET_MISMATCH("Failure_LockSecret_Secret_Mismatch"),
  
  FAILURE_LOCKSECRET_UNKNOWN_COMPOSITE_KEY("Failure_LockSecret_Unknown_Composite_Key"),
  
  FAILURE_LOCKSECRET_INACTIVE_SECRET("Failure_LockSecret_Inactive_Secret"),
  
  FAILURE_LOCKSECRET_HASH_ALGORITHM_MISMATCH("Failure_LockSecret_Hash_Algorithm_Mismatch"),
  
  FAILURE_LOCKSECRET_INVALID_DURATION("Failure_LockSecret_Invalid_Duration"),
  
  FAILURE_METADATA_VALUE_TOO_SMALL("Failure_Metadata_Value_Too_Small"),
  
  FAILURE_METADATA_VALUE_TOO_LARGE("Failure_Metadata_Value_Too_Large"),
  
  FAILURE_METADATA_VALUE_SIZE_DELTA_TOO_LARGE("Failure_Metadata_Value_Size_Delta_Too_Large"),
  
  FAILURE_METADATA_VALUE_SIZE_DELTA_MISMATCH("Failure_Metadata_Value_Size_Delta_Mismatch"),
  
  FAILURE_METADATA_VALUE_CHANGE_IRREVERSIBLE("Failure_Metadata_Value_Change_Irreversible"),
  
  FAILURE_MOSAIC_INVALID_DURATION("Failure_Mosaic_Invalid_Duration"),
  
  FAILURE_MOSAIC_INVALID_NAME("Failure_Mosaic_Invalid_Name"),
  
  FAILURE_MOSAIC_NAME_ID_MISMATCH("Failure_Mosaic_Name_Id_Mismatch"),
  
  FAILURE_MOSAIC_EXPIRED("Failure_Mosaic_Expired"),
  
  FAILURE_MOSAIC_OWNER_CONFLICT("Failure_Mosaic_Owner_Conflict"),
  
  FAILURE_MOSAIC_ID_MISMATCH("Failure_Mosaic_Id_Mismatch"),
  
  FAILURE_MOSAIC_PARENT_ID_CONFLICT("Failure_Mosaic_Parent_Id_Conflict"),
  
  FAILURE_MOSAIC_INVALID_PROPERTY("Failure_Mosaic_Invalid_Property"),
  
  FAILURE_MOSAIC_INVALID_FLAGS("Failure_Mosaic_Invalid_Flags"),
  
  FAILURE_MOSAIC_INVALID_DIVISIBILITY("Failure_Mosaic_Invalid_Divisibility"),
  
  FAILURE_MOSAIC_INVALID_SUPPLY_CHANGE_ACTION("Failure_Mosaic_Invalid_Supply_Change_Action"),
  
  FAILURE_MOSAIC_INVALID_SUPPLY_CHANGE_AMOUNT("Failure_Mosaic_Invalid_Supply_Change_Amount"),
  
  FAILURE_MOSAIC_INVALID_ID("Failure_Mosaic_Invalid_Id"),
  
  FAILURE_MOSAIC_MODIFICATION_DISALLOWED("Failure_Mosaic_Modification_Disallowed"),
  
  FAILURE_MOSAIC_MODIFICATION_NO_CHANGES("Failure_Mosaic_Modification_No_Changes"),
  
  FAILURE_MOSAIC_SUPPLY_IMMUTABLE("Failure_Mosaic_Supply_Immutable"),
  
  FAILURE_MOSAIC_SUPPLY_NEGATIVE("Failure_Mosaic_Supply_Negative"),
  
  FAILURE_MOSAIC_SUPPLY_EXCEEDED("Failure_Mosaic_Supply_Exceeded"),
  
  FAILURE_MOSAIC_NON_TRANSFERABLE("Failure_Mosaic_Non_Transferable"),
  
  FAILURE_MOSAIC_MAX_MOSAICS_EXCEEDED("Failure_Mosaic_Max_Mosaics_Exceeded"),
  
  FAILURE_MOSAIC_REQUIRED_PROPERTY_FLAG_UNSET("Failure_Mosaic_Required_Property_Flag_Unset"),
  
  FAILURE_MULTISIG_ACCOUNT_IN_BOTH_SETS("Failure_Multisig_Account_In_Both_Sets"),
  
  FAILURE_MULTISIG_MULTIPLE_DELETES("Failure_Multisig_Multiple_Deletes"),
  
  FAILURE_MULTISIG_REDUNDANT_MODIFICATION("Failure_Multisig_Redundant_Modification"),
  
  FAILURE_MULTISIG_UNKNOWN_MULTISIG_ACCOUNT("Failure_Multisig_Unknown_Multisig_Account"),
  
  FAILURE_MULTISIG_NOT_A_COSIGNATORY("Failure_Multisig_Not_A_Cosignatory"),
  
  FAILURE_MULTISIG_ALREADY_A_COSIGNATORY("Failure_Multisig_Already_A_Cosignatory"),
  
  FAILURE_MULTISIG_MIN_SETTING_OUT_OF_RANGE("Failure_Multisig_Min_Setting_Out_Of_Range"),
  
  FAILURE_MULTISIG_MIN_SETTING_LARGER_THAN_NUM_COSIGNATORIES("Failure_Multisig_Min_Setting_Larger_Than_Num_Cosignatories"),
  
  FAILURE_MULTISIG_INVALID_MODIFICATION_ACTION("Failure_Multisig_Invalid_Modification_Action"),
  
  FAILURE_MULTISIG_MAX_COSIGNED_ACCOUNTS("Failure_Multisig_Max_Cosigned_Accounts"),
  
  FAILURE_MULTISIG_MAX_COSIGNATORIES("Failure_Multisig_Max_Cosignatories"),
  
  FAILURE_MULTISIG_LOOP("Failure_Multisig_Loop"),
  
  FAILURE_MULTISIG_MAX_MULTISIG_DEPTH("Failure_Multisig_Max_Multisig_Depth"),
  
  FAILURE_MULTISIG_OPERATION_PROHIBITED_BY_ACCOUNT("Failure_Multisig_Operation_Prohibited_By_Account"),
  
  FAILURE_NAMESPACE_INVALID_DURATION("Failure_Namespace_Invalid_Duration"),
  
  FAILURE_NAMESPACE_INVALID_NAME("Failure_Namespace_Invalid_Name"),
  
  FAILURE_NAMESPACE_NAME_ID_MISMATCH("Failure_Namespace_Name_Id_Mismatch"),
  
  FAILURE_NAMESPACE_EXPIRED("Failure_Namespace_Expired"),
  
  FAILURE_NAMESPACE_OWNER_CONFLICT("Failure_Namespace_Owner_Conflict"),
  
  FAILURE_NAMESPACE_ID_MISMATCH("Failure_Namespace_Id_Mismatch"),
  
  FAILURE_NAMESPACE_INVALID_REGISTRATION_TYPE("Failure_Namespace_Invalid_Registration_Type"),
  
  FAILURE_NAMESPACE_ROOT_NAME_RESERVED("Failure_Namespace_Root_Name_Reserved"),
  
  FAILURE_NAMESPACE_TOO_DEEP("Failure_Namespace_Too_Deep"),
  
  FAILURE_NAMESPACE_UNKNOWN_PARENT("Failure_Namespace_Unknown_Parent"),
  
  FAILURE_NAMESPACE_ALREADY_EXISTS("Failure_Namespace_Already_Exists"),
  
  FAILURE_NAMESPACE_ALREADY_ACTIVE("Failure_Namespace_Already_Active"),
  
  FAILURE_NAMESPACE_ETERNAL_AFTER_NEMESIS_BLOCK("Failure_Namespace_Eternal_After_Nemesis_Block"),
  
  FAILURE_NAMESPACE_MAX_CHILDREN_EXCEEDED("Failure_Namespace_Max_Children_Exceeded"),
  
  FAILURE_NAMESPACE_ALIAS_INVALID_ACTION("Failure_Namespace_Alias_Invalid_Action"),
  
  FAILURE_NAMESPACE_UNKNOWN("Failure_Namespace_Unknown"),
  
  FAILURE_NAMESPACE_ALIAS_ALREADY_EXISTS("Failure_Namespace_Alias_Already_Exists"),
  
  FAILURE_NAMESPACE_UNKNOWN_ALIAS("Failure_Namespace_Unknown_Alias"),
  
  FAILURE_NAMESPACE_ALIAS_INCONSISTENT_UNLINK_TYPE("Failure_Namespace_Alias_Inconsistent_Unlink_Type"),
  
  FAILURE_NAMESPACE_ALIAS_INCONSISTENT_UNLINK_DATA("Failure_Namespace_Alias_Inconsistent_Unlink_Data"),
  
  FAILURE_NAMESPACE_ALIAS_INVALID_ADDRESS("Failure_Namespace_Alias_Invalid_Address"),
  
  FAILURE_RESTRICTIONACCOUNT_INVALID_RESTRICTION_FLAGS("Failure_RestrictionAccount_Invalid_Restriction_Flags"),
  
  FAILURE_RESTRICTIONACCOUNT_INVALID_MODIFICATION_ACTION("Failure_RestrictionAccount_Invalid_Modification_Action"),
  
  FAILURE_RESTRICTIONACCOUNT_INVALID_MODIFICATION_ADDRESS("Failure_RestrictionAccount_Invalid_Modification_Address"),
  
  FAILURE_RESTRICTIONACCOUNT_MODIFICATION_OPERATION_TYPE_INCOMPATIBLE("Failure_RestrictionAccount_Modification_Operation_Type_Incompatible"),
  
  FAILURE_RESTRICTIONACCOUNT_REDUNDANT_MODIFICATION("Failure_RestrictionAccount_Redundant_Modification"),
  
  FAILURE_RESTRICTIONACCOUNT_INVALID_MODIFICATION("Failure_RestrictionAccount_Invalid_Modification"),
  
  FAILURE_RESTRICTIONACCOUNT_MODIFICATION_COUNT_EXCEEDED("Failure_RestrictionAccount_Modification_Count_Exceeded"),
  
  FAILURE_RESTRICTIONACCOUNT_NO_MODIFICATIONS("Failure_RestrictionAccount_No_Modifications"),
  
  FAILURE_RESTRICTIONACCOUNT_VALUES_COUNT_EXCEEDED("Failure_RestrictionAccount_Values_Count_Exceeded"),
  
  FAILURE_RESTRICTIONACCOUNT_INVALID_VALUE("Failure_RestrictionAccount_Invalid_Value"),
  
  FAILURE_RESTRICTIONACCOUNT_ADDRESS_INTERACTION_PROHIBITED("Failure_RestrictionAccount_Address_Interaction_Prohibited"),
  
  FAILURE_RESTRICTIONACCOUNT_MOSAIC_TRANSFER_PROHIBITED("Failure_RestrictionAccount_Mosaic_Transfer_Prohibited"),
  
  FAILURE_RESTRICTIONACCOUNT_OPERATION_TYPE_PROHIBITED("Failure_RestrictionAccount_Operation_Type_Prohibited"),
  
  FAILURE_RESTRICTIONMOSAIC_INVALID_RESTRICTION_TYPE("Failure_RestrictionMosaic_Invalid_Restriction_Type"),
  
  FAILURE_RESTRICTIONMOSAIC_PREVIOUS_VALUE_MISMATCH("Failure_RestrictionMosaic_Previous_Value_Mismatch"),
  
  FAILURE_RESTRICTIONMOSAIC_PREVIOUS_VALUE_MUST_BE_ZERO("Failure_RestrictionMosaic_Previous_Value_Must_Be_Zero"),
  
  FAILURE_RESTRICTIONMOSAIC_MAX_RESTRICTIONS_EXCEEDED("Failure_RestrictionMosaic_Max_Restrictions_Exceeded"),
  
  FAILURE_RESTRICTIONMOSAIC_CANNOT_DELETE_NONEXISTENT_RESTRICTION("Failure_RestrictionMosaic_Cannot_Delete_Nonexistent_Restriction"),
  
  FAILURE_RESTRICTIONMOSAIC_UNKNOWN_GLOBAL_RESTRICTION("Failure_RestrictionMosaic_Unknown_Global_Restriction"),
  
  FAILURE_RESTRICTIONMOSAIC_INVALID_GLOBAL_RESTRICTION("Failure_RestrictionMosaic_Invalid_Global_Restriction"),
  
  FAILURE_RESTRICTIONMOSAIC_ACCOUNT_UNAUTHORIZED("Failure_RestrictionMosaic_Account_Unauthorized"),
  
  FAILURE_TRANSFER_MESSAGE_TOO_LARGE("Failure_Transfer_Message_Too_Large"),
  
  FAILURE_TRANSFER_OUT_OF_ORDER_MOSAICS("Failure_Transfer_Out_Of_Order_Mosaics"),
  
  FAILURE_CHAIN_UNLINKED("Failure_Chain_Unlinked"),
  
  FAILURE_CHAIN_BLOCK_NOT_HIT("Failure_Chain_Block_Not_Hit"),
  
  FAILURE_CHAIN_BLOCK_INCONSISTENT_STATE_HASH("Failure_Chain_Block_Inconsistent_State_Hash"),
  
  FAILURE_CHAIN_BLOCK_INCONSISTENT_RECEIPTS_HASH("Failure_Chain_Block_Inconsistent_Receipts_Hash"),
  
  FAILURE_CHAIN_UNCONFIRMED_CACHE_TOO_FULL("Failure_Chain_Unconfirmed_Cache_Too_Full"),
  
  FAILURE_CONSUMER_EMPTY_INPUT("Failure_Consumer_Empty_Input"),
  
  FAILURE_CONSUMER_BLOCK_TRANSACTIONS_HASH_MISMATCH("Failure_Consumer_Block_Transactions_Hash_Mismatch"),
  
  NEUTRAL_CONSUMER_HASH_IN_RECENCY_CACHE("Neutral_Consumer_Hash_In_Recency_Cache"),
  
  FAILURE_CONSUMER_REMOTE_CHAIN_TOO_MANY_BLOCKS("Failure_Consumer_Remote_Chain_Too_Many_Blocks"),
  
  FAILURE_CONSUMER_REMOTE_CHAIN_IMPROPER_LINK("Failure_Consumer_Remote_Chain_Improper_Link"),
  
  FAILURE_CONSUMER_REMOTE_CHAIN_DUPLICATE_TRANSACTIONS("Failure_Consumer_Remote_Chain_Duplicate_Transactions"),
  
  FAILURE_CONSUMER_REMOTE_CHAIN_UNLINKED("Failure_Consumer_Remote_Chain_Unlinked"),
  
  FAILURE_CONSUMER_REMOTE_CHAIN_DIFFICULTIES_MISMATCH("Failure_Consumer_Remote_Chain_Difficulties_Mismatch"),
  
  FAILURE_CONSUMER_REMOTE_CHAIN_SCORE_NOT_BETTER("Failure_Consumer_Remote_Chain_Score_Not_Better"),
  
  FAILURE_CONSUMER_REMOTE_CHAIN_TOO_FAR_BEHIND("Failure_Consumer_Remote_Chain_Too_Far_Behind"),
  
  FAILURE_CONSUMER_REMOTE_CHAIN_TOO_FAR_IN_FUTURE("Failure_Consumer_Remote_Chain_Too_Far_In_Future"),
  
  FAILURE_CONSUMER_BATCH_SIGNATURE_NOT_VERIFIABLE("Failure_Consumer_Batch_Signature_Not_Verifiable"),
  
  FAILURE_EXTENSION_PARTIAL_TRANSACTION_CACHE_PRUNE("Failure_Extension_Partial_Transaction_Cache_Prune"),
  
  FAILURE_EXTENSION_PARTIAL_TRANSACTION_DEPENDENCY_REMOVED("Failure_Extension_Partial_Transaction_Dependency_Removed"),
  
  FAILURE_EXTENSION_READ_RATE_LIMIT_EXCEEDED("Failure_Extension_Read_Rate_Limit_Exceeded");

  private String value;

  TransactionStatusTypeEnum(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static TransactionStatusTypeEnum fromValue(String value) {
    for (TransactionStatusTypeEnum b : TransactionStatusTypeEnum.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

