package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.AccountIds;
import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicAddressRestrictionDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicGlobalRestrictionDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicIds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-09T15:36:22.379Z[UTC]")
public class RestrictionMosaicRoutesApi {
  private ApiClient apiClient;

  public RestrictionMosaicRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public RestrictionMosaicRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Get mosaic address restrictions for a given mosaic and account identifier.
   * Get mosaic address restriction.
   * @param mosaicId Mosaic identifier. (required)
   * @param accountId Account public key or address enconded using a 32-character set. (required)
   * @return MosaicAddressRestrictionDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MosaicAddressRestrictionDTO getMosaicAddressRestriction(String mosaicId, String accountId) throws ApiException {
    return getMosaicAddressRestrictionWithHttpInfo(mosaicId, accountId).getData();
  }

  /**
   * Get mosaic address restrictions for a given mosaic and account identifier.
   * Get mosaic address restriction.
   * @param mosaicId Mosaic identifier. (required)
   * @param accountId Account public key or address enconded using a 32-character set. (required)
   * @return ApiResponse&lt;MosaicAddressRestrictionDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MosaicAddressRestrictionDTO> getMosaicAddressRestrictionWithHttpInfo(String mosaicId, String accountId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'mosaicId' is set
    if (mosaicId == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicAddressRestriction");
    }
    
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling getMosaicAddressRestriction");
    }
    
    // create path and map variables
    String localVarPath = "/restrictions/mosaic/{mosaicId}/address/{accountId}"
      .replaceAll("\\{" + "mosaicId" + "\\}", apiClient.escapeString(mosaicId.toString()))
      .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MosaicAddressRestrictionDTO> localVarReturnType = new GenericType<MosaicAddressRestrictionDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get mosaic address restrictions for a given mosaic and account identifiers array.
   * Get mosaic address restrictions.
   * @param mosaicId Mosaic identifier. (required)
   * @param accountIds  (optional)
   * @return List&lt;MosaicAddressRestrictionDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<MosaicAddressRestrictionDTO> getMosaicAddressRestrictions(String mosaicId, AccountIds accountIds) throws ApiException {
    return getMosaicAddressRestrictionsWithHttpInfo(mosaicId, accountIds).getData();
  }

  /**
   * Get mosaic address restrictions for a given mosaic and account identifiers array.
   * Get mosaic address restrictions.
   * @param mosaicId Mosaic identifier. (required)
   * @param accountIds  (optional)
   * @return ApiResponse&lt;List&lt;MosaicAddressRestrictionDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<MosaicAddressRestrictionDTO>> getMosaicAddressRestrictionsWithHttpInfo(String mosaicId, AccountIds accountIds) throws ApiException {
    Object localVarPostBody = accountIds;
    
    // verify the required parameter 'mosaicId' is set
    if (mosaicId == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicAddressRestrictions");
    }
    
    // create path and map variables
    String localVarPath = "/restrictions/mosaic/{mosaicId}"
      .replaceAll("\\{" + "mosaicId" + "\\}", apiClient.escapeString(mosaicId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<MosaicAddressRestrictionDTO>> localVarReturnType = new GenericType<List<MosaicAddressRestrictionDTO>>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get mosaic global restriction for a given mosaic identifier.
   * Get mosaic global restriction.
   * @param mosaicId Mosaic identifier. (required)
   * @return MosaicGlobalRestrictionDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MosaicGlobalRestrictionDTO getMosaicGlobalRestriction(String mosaicId) throws ApiException {
    return getMosaicGlobalRestrictionWithHttpInfo(mosaicId).getData();
  }

  /**
   * Get mosaic global restriction for a given mosaic identifier.
   * Get mosaic global restriction.
   * @param mosaicId Mosaic identifier. (required)
   * @return ApiResponse&lt;MosaicGlobalRestrictionDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MosaicGlobalRestrictionDTO> getMosaicGlobalRestrictionWithHttpInfo(String mosaicId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'mosaicId' is set
    if (mosaicId == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicGlobalRestriction");
    }
    
    // create path and map variables
    String localVarPath = "/restrictions/mosaic/{mosaicId}"
      .replaceAll("\\{" + "mosaicId" + "\\}", apiClient.escapeString(mosaicId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MosaicGlobalRestrictionDTO> localVarReturnType = new GenericType<MosaicGlobalRestrictionDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get mosaic global restrictions for an array of mosaics.
   * Get mosaic global restrictions.
   * @param mosaicIds  (required)
   * @return List&lt;MosaicGlobalRestrictionDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<MosaicGlobalRestrictionDTO> getMosaicGlobalRestrictions(MosaicIds mosaicIds) throws ApiException {
    return getMosaicGlobalRestrictionsWithHttpInfo(mosaicIds).getData();
  }

  /**
   * Get mosaic global restrictions for an array of mosaics.
   * Get mosaic global restrictions.
   * @param mosaicIds  (required)
   * @return ApiResponse&lt;List&lt;MosaicGlobalRestrictionDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<MosaicGlobalRestrictionDTO>> getMosaicGlobalRestrictionsWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
    Object localVarPostBody = mosaicIds;
    
    // verify the required parameter 'mosaicIds' is set
    if (mosaicIds == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicIds' when calling getMosaicGlobalRestrictions");
    }
    
    // create path and map variables
    String localVarPath = "/restrictions/mosaic";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<MosaicGlobalRestrictionDTO>> localVarReturnType = new GenericType<List<MosaicGlobalRestrictionDTO>>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
