package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkConfigurationDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkFeesDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeDTO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-09T15:36:22.379Z[UTC]")
public class NetworkRoutesApi {
  private ApiClient apiClient;

  public NetworkRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public NetworkRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Get transaction fees information
   * Returns information about the average, median, highest and lower fee multiplier over the last \&quot;numBlocksTransactionFeeStats\&quot;. The setting \&quot;numBlocksTransactionFeeStats\&quot; is adjustable via a configuration file (rest/resources/rest.json) per REST instance. 
   * @return NetworkFeesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
     </table>
   */
  public NetworkFeesDTO getNetworkFees() throws ApiException {
    return getNetworkFeesWithHttpInfo().getData();
  }

  /**
   * Get transaction fees information
   * Returns information about the average, median, highest and lower fee multiplier over the last \&quot;numBlocksTransactionFeeStats\&quot;. The setting \&quot;numBlocksTransactionFeeStats\&quot; is adjustable via a configuration file (rest/resources/rest.json) per REST instance. 
   * @return ApiResponse&lt;NetworkFeesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<NetworkFeesDTO> getNetworkFeesWithHttpInfo() throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/network/fees";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<NetworkFeesDTO> localVarReturnType = new GenericType<NetworkFeesDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get the network properties
   * Returns the content from a catapult-server network configuration file (resources/config-network.properties). To enable this feature, the REST setting \&quot;network.propertiesFilePath\&quot; must define where the file is located. This is adjustable via the configuration file (rest/resources/rest.json) per REST instance. 
   * @return NetworkConfigurationDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public NetworkConfigurationDTO getNetworkProperties() throws ApiException {
    return getNetworkPropertiesWithHttpInfo().getData();
  }

  /**
   * Get the network properties
   * Returns the content from a catapult-server network configuration file (resources/config-network.properties). To enable this feature, the REST setting \&quot;network.propertiesFilePath\&quot; must define where the file is located. This is adjustable via the configuration file (rest/resources/rest.json) per REST instance. 
   * @return ApiResponse&lt;NetworkConfigurationDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<NetworkConfigurationDTO> getNetworkPropertiesWithHttpInfo() throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/network/properties";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<NetworkConfigurationDTO> localVarReturnType = new GenericType<NetworkConfigurationDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get the current network type of the chain
   * Returns the current network type.
   * @return NetworkTypeDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
     </table>
   */
  public NetworkTypeDTO getNetworkType() throws ApiException {
    return getNetworkTypeWithHttpInfo().getData();
  }

  /**
   * Get the current network type of the chain
   * Returns the current network type.
   * @return ApiResponse&lt;NetworkTypeDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<NetworkTypeDTO> getNetworkTypeWithHttpInfo() throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/network";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<NetworkTypeDTO> localVarReturnType = new GenericType<NetworkTypeDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
