package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.AccountIds;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountsNamesDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicIds;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicsNamesDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceIds;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceNameDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespacesInfoDTO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-09T15:36:22.379Z[UTC]")
public class NamespaceRoutesApi {
  private ApiClient apiClient;

  public NamespaceRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public NamespaceRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Get readable names for a set of accountIds
   * Returns friendly names for accounts.
   * @param accountIds  (optional)
   * @return AccountsNamesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public AccountsNamesDTO getAccountsNames(AccountIds accountIds) throws ApiException {
    return getAccountsNamesWithHttpInfo(accountIds).getData();
  }

  /**
   * Get readable names for a set of accountIds
   * Returns friendly names for accounts.
   * @param accountIds  (optional)
   * @return ApiResponse&lt;AccountsNamesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<AccountsNamesDTO> getAccountsNamesWithHttpInfo(AccountIds accountIds) throws ApiException {
    Object localVarPostBody = accountIds;
    
    // create path and map variables
    String localVarPath = "/account/names";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<AccountsNamesDTO> localVarReturnType = new GenericType<AccountsNamesDTO>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get readable names for a set of mosaics
   * Returns friendly names for mosaics.
   * @param mosaicIds  (required)
   * @return MosaicsNamesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MosaicsNamesDTO getMosaicsNames(MosaicIds mosaicIds) throws ApiException {
    return getMosaicsNamesWithHttpInfo(mosaicIds).getData();
  }

  /**
   * Get readable names for a set of mosaics
   * Returns friendly names for mosaics.
   * @param mosaicIds  (required)
   * @return ApiResponse&lt;MosaicsNamesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MosaicsNamesDTO> getMosaicsNamesWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
    Object localVarPostBody = mosaicIds;
    
    // verify the required parameter 'mosaicIds' is set
    if (mosaicIds == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicIds' when calling getMosaicsNames");
    }
    
    // create path and map variables
    String localVarPath = "/mosaic/names";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MosaicsNamesDTO> localVarReturnType = new GenericType<MosaicsNamesDTO>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get namespace information
   * Gets the namespace for a given namespace identifier.
   * @param namespaceId Namespace identifier. (required)
   * @return NamespaceInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public NamespaceInfoDTO getNamespace(String namespaceId) throws ApiException {
    return getNamespaceWithHttpInfo(namespaceId).getData();
  }

  /**
   * Get namespace information
   * Gets the namespace for a given namespace identifier.
   * @param namespaceId Namespace identifier. (required)
   * @return ApiResponse&lt;NamespaceInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<NamespaceInfoDTO> getNamespaceWithHttpInfo(String namespaceId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'namespaceId' is set
    if (namespaceId == null) {
      throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespace");
    }
    
    // create path and map variables
    String localVarPath = "/namespace/{namespaceId}"
      .replaceAll("\\{" + "namespaceId" + "\\}", apiClient.escapeString(namespaceId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<NamespaceInfoDTO> localVarReturnType = new GenericType<NamespaceInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get namespaces created by an account
   * Gets an array of namespaces for a given account address.
   * @param accountId Account public key or address enconded using a 32-character set. (required)
   * @param pageSize Number of transactions to return for each request. (optional, default to 10)
   * @param id Namespace identifier up to which transactions are returned. (optional)
   * @return NamespacesInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public NamespacesInfoDTO getNamespacesFromAccount(String accountId, Integer pageSize, String id) throws ApiException {
    return getNamespacesFromAccountWithHttpInfo(accountId, pageSize, id).getData();
  }

  /**
   * Get namespaces created by an account
   * Gets an array of namespaces for a given account address.
   * @param accountId Account public key or address enconded using a 32-character set. (required)
   * @param pageSize Number of transactions to return for each request. (optional, default to 10)
   * @param id Namespace identifier up to which transactions are returned. (optional)
   * @return ApiResponse&lt;NamespacesInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<NamespacesInfoDTO> getNamespacesFromAccountWithHttpInfo(String accountId, Integer pageSize, String id) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling getNamespacesFromAccount");
    }
    
    // create path and map variables
    String localVarPath = "/account/{accountId}/namespaces"
      .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<NamespacesInfoDTO> localVarReturnType = new GenericType<NamespacesInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get namespaces for given array of addresses
   * Gets namespaces for a given array of addresses.
   * @param accountIds  (optional)
   * @return NamespacesInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public NamespacesInfoDTO getNamespacesFromAccounts(AccountIds accountIds) throws ApiException {
    return getNamespacesFromAccountsWithHttpInfo(accountIds).getData();
  }

  /**
   * Get namespaces for given array of addresses
   * Gets namespaces for a given array of addresses.
   * @param accountIds  (optional)
   * @return ApiResponse&lt;NamespacesInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<NamespacesInfoDTO> getNamespacesFromAccountsWithHttpInfo(AccountIds accountIds) throws ApiException {
    Object localVarPostBody = accountIds;
    
    // create path and map variables
    String localVarPath = "/account/namespaces";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<NamespacesInfoDTO> localVarReturnType = new GenericType<NamespacesInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get readable names for a set of namespaces
   * Returns friendly names for namespaces.
   * @param namespaceIds  (required)
   * @return List&lt;NamespaceNameDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<NamespaceNameDTO> getNamespacesNames(NamespaceIds namespaceIds) throws ApiException {
    return getNamespacesNamesWithHttpInfo(namespaceIds).getData();
  }

  /**
   * Get readable names for a set of namespaces
   * Returns friendly names for namespaces.
   * @param namespaceIds  (required)
   * @return ApiResponse&lt;List&lt;NamespaceNameDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<NamespaceNameDTO>> getNamespacesNamesWithHttpInfo(NamespaceIds namespaceIds) throws ApiException {
    Object localVarPostBody = namespaceIds;
    
    // verify the required parameter 'namespaceIds' is set
    if (namespaceIds == null) {
      throw new ApiException(400, "Missing the required parameter 'namespaceIds' when calling getNamespacesNames");
    }
    
    // create path and map variables
    String localVarPath = "/namespace/names";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<NamespaceNameDTO>> localVarReturnType = new GenericType<List<NamespaceNameDTO>>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
