/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.nem.symbol.sdk.openapi.jersey2.model.ResolutionStatementDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.TransactionStatementDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Collection of transaction statements and resolutions triggered for the block requested.")
public class StatementsDTO {
    public static final String JSON_PROPERTY_TRANSACTION_STATEMENTS = "transactionStatements";
    @JsonProperty(value="transactionStatements")
    private List<TransactionStatementDTO> transactionStatements = new ArrayList<TransactionStatementDTO>();
    public static final String JSON_PROPERTY_ADDRESS_RESOLUTION_STATEMENTS = "addressResolutionStatements";
    @JsonProperty(value="addressResolutionStatements")
    private List<ResolutionStatementDTO> addressResolutionStatements = new ArrayList<ResolutionStatementDTO>();
    public static final String JSON_PROPERTY_MOSAIC_RESOLUTION_STATEMENTS = "mosaicResolutionStatements";
    @JsonProperty(value="mosaicResolutionStatements")
    private List<ResolutionStatementDTO> mosaicResolutionStatements = new ArrayList<ResolutionStatementDTO>();

    public StatementsDTO transactionStatements(List<TransactionStatementDTO> transactionStatements) {
        this.transactionStatements = transactionStatements;
        return this;
    }

    public StatementsDTO addTransactionStatementsItem(TransactionStatementDTO transactionStatementsItem) {
        this.transactionStatements.add(transactionStatementsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of transaction statements for the block requested.")
    public List<TransactionStatementDTO> getTransactionStatements() {
        return this.transactionStatements;
    }

    public void setTransactionStatements(List<TransactionStatementDTO> transactionStatements) {
        this.transactionStatements = transactionStatements;
    }

    public StatementsDTO addressResolutionStatements(List<ResolutionStatementDTO> addressResolutionStatements) {
        this.addressResolutionStatements = addressResolutionStatements;
        return this;
    }

    public StatementsDTO addAddressResolutionStatementsItem(ResolutionStatementDTO addressResolutionStatementsItem) {
        this.addressResolutionStatements.add(addressResolutionStatementsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of address resolutions for the block requested.")
    public List<ResolutionStatementDTO> getAddressResolutionStatements() {
        return this.addressResolutionStatements;
    }

    public void setAddressResolutionStatements(List<ResolutionStatementDTO> addressResolutionStatements) {
        this.addressResolutionStatements = addressResolutionStatements;
    }

    public StatementsDTO mosaicResolutionStatements(List<ResolutionStatementDTO> mosaicResolutionStatements) {
        this.mosaicResolutionStatements = mosaicResolutionStatements;
        return this;
    }

    public StatementsDTO addMosaicResolutionStatementsItem(ResolutionStatementDTO mosaicResolutionStatementsItem) {
        this.mosaicResolutionStatements.add(mosaicResolutionStatementsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of mosaic resolutions for the block requested.")
    public List<ResolutionStatementDTO> getMosaicResolutionStatements() {
        return this.mosaicResolutionStatements;
    }

    public void setMosaicResolutionStatements(List<ResolutionStatementDTO> mosaicResolutionStatements) {
        this.mosaicResolutionStatements = mosaicResolutionStatements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatementsDTO statementsDTO = (StatementsDTO)o;
        return Objects.equals(this.transactionStatements, statementsDTO.transactionStatements) && Objects.equals(this.addressResolutionStatements, statementsDTO.addressResolutionStatements) && Objects.equals(this.mosaicResolutionStatements, statementsDTO.mosaicResolutionStatements);
    }

    public int hashCode() {
        return Objects.hash(this.transactionStatements, this.addressResolutionStatements, this.mosaicResolutionStatements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatementsDTO {\n");
        sb.append("    transactionStatements: ").append(this.toIndentedString(this.transactionStatements)).append("\n");
        sb.append("    addressResolutionStatements: ").append(this.toIndentedString(this.addressResolutionStatements)).append("\n");
        sb.append("    mosaicResolutionStatements: ").append(this.toIndentedString(this.mosaicResolutionStatements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

