/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Transaction to set a restriction rule to an address.")
public class MosaicAddressRestrictionTransactionDTO {
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    @JsonProperty(value="signature")
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @JsonProperty(value="signerPublicKey")
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    @JsonProperty(value="version")
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    @JsonProperty(value="network")
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    @JsonProperty(value="maxFee")
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    @JsonProperty(value="deadline")
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
    @JsonProperty(value="mosaicId")
    private String mosaicId;
    public static final String JSON_PROPERTY_RESTRICTION_KEY = "restrictionKey";
    @JsonProperty(value="restrictionKey")
    private String restrictionKey;
    public static final String JSON_PROPERTY_PREVIOUS_RESTRICTION_VALUE = "previousRestrictionValue";
    @JsonProperty(value="previousRestrictionValue")
    private BigInteger previousRestrictionValue = null;
    public static final String JSON_PROPERTY_NEW_RESTRICTION_VALUE = "newRestrictionValue";
    @JsonProperty(value="newRestrictionValue")
    private BigInteger newRestrictionValue = null;
    public static final String JSON_PROPERTY_TARGET_ADDRESS = "targetAddress";
    @JsonProperty(value="targetAddress")
    private String targetAddress;

    public MosaicAddressRestrictionTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public MosaicAddressRestrictionTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public MosaicAddressRestrictionTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public MosaicAddressRestrictionTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public MosaicAddressRestrictionTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public MosaicAddressRestrictionTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public MosaicAddressRestrictionTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public MosaicAddressRestrictionTransactionDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public MosaicAddressRestrictionTransactionDTO restrictionKey(String restrictionKey) {
        this.restrictionKey = restrictionKey;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Restriction key.")
    public String getRestrictionKey() {
        return this.restrictionKey;
    }

    public void setRestrictionKey(String restrictionKey) {
        this.restrictionKey = restrictionKey;
    }

    public MosaicAddressRestrictionTransactionDTO previousRestrictionValue(BigInteger previousRestrictionValue) {
        this.previousRestrictionValue = previousRestrictionValue;
        return this;
    }

    @ApiModelProperty(example="1000", required=true, value="Restriction value.")
    public BigInteger getPreviousRestrictionValue() {
        return this.previousRestrictionValue;
    }

    public void setPreviousRestrictionValue(BigInteger previousRestrictionValue) {
        this.previousRestrictionValue = previousRestrictionValue;
    }

    public MosaicAddressRestrictionTransactionDTO newRestrictionValue(BigInteger newRestrictionValue) {
        this.newRestrictionValue = newRestrictionValue;
        return this;
    }

    @ApiModelProperty(example="1000", required=true, value="Restriction value.")
    public BigInteger getNewRestrictionValue() {
        return this.newRestrictionValue;
    }

    public void setNewRestrictionValue(BigInteger newRestrictionValue) {
        this.newRestrictionValue = newRestrictionValue;
    }

    public MosaicAddressRestrictionTransactionDTO targetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E01A", required=true, value="Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
    public String getTargetAddress() {
        return this.targetAddress;
    }

    public void setTargetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MosaicAddressRestrictionTransactionDTO mosaicAddressRestrictionTransactionDTO = (MosaicAddressRestrictionTransactionDTO)o;
        return Objects.equals(this.signature, mosaicAddressRestrictionTransactionDTO.signature) && Objects.equals(this.signerPublicKey, mosaicAddressRestrictionTransactionDTO.signerPublicKey) && Objects.equals(this.version, mosaicAddressRestrictionTransactionDTO.version) && Objects.equals((Object)this.network, (Object)mosaicAddressRestrictionTransactionDTO.network) && Objects.equals(this.type, mosaicAddressRestrictionTransactionDTO.type) && Objects.equals(this.maxFee, mosaicAddressRestrictionTransactionDTO.maxFee) && Objects.equals(this.deadline, mosaicAddressRestrictionTransactionDTO.deadline) && Objects.equals(this.mosaicId, mosaicAddressRestrictionTransactionDTO.mosaicId) && Objects.equals(this.restrictionKey, mosaicAddressRestrictionTransactionDTO.restrictionKey) && Objects.equals(this.previousRestrictionValue, mosaicAddressRestrictionTransactionDTO.previousRestrictionValue) && Objects.equals(this.newRestrictionValue, mosaicAddressRestrictionTransactionDTO.newRestrictionValue) && Objects.equals(this.targetAddress, mosaicAddressRestrictionTransactionDTO.targetAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.mosaicId, this.restrictionKey, this.previousRestrictionValue, this.newRestrictionValue, this.targetAddress});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MosaicAddressRestrictionTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    restrictionKey: ").append(this.toIndentedString(this.restrictionKey)).append("\n");
        sb.append("    previousRestrictionValue: ").append(this.toIndentedString(this.previousRestrictionValue)).append("\n");
        sb.append("    newRestrictionValue: ").append(this.toIndentedString(this.newRestrictionValue)).append("\n");
        sb.append("    targetAddress: ").append(this.toIndentedString(this.targetAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

