/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountIds;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountsNamesDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicIds;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicsNamesDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceIds;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceNameDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespacesInfoDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class NamespaceRoutesApi {
    private ApiClient apiClient;

    public NamespaceRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NamespaceRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AccountsNamesDTO getAccountsNames(AccountIds accountIds) throws ApiException {
        return this.getAccountsNamesWithHttpInfo(accountIds).getData();
    }

    public ApiResponse<AccountsNamesDTO> getAccountsNamesWithHttpInfo(AccountIds accountIds) throws ApiException {
        AccountIds localVarPostBody = accountIds;
        String localVarPath = "/account/names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AccountsNamesDTO> localVarReturnType = new GenericType<AccountsNamesDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MosaicsNamesDTO getMosaicsNames(MosaicIds mosaicIds) throws ApiException {
        return this.getMosaicsNamesWithHttpInfo(mosaicIds).getData();
    }

    public ApiResponse<MosaicsNamesDTO> getMosaicsNamesWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
        MosaicIds localVarPostBody = mosaicIds;
        if (mosaicIds == null) {
            throw new ApiException(400, "Missing the required parameter 'mosaicIds' when calling getMosaicsNames");
        }
        String localVarPath = "/mosaic/names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MosaicsNamesDTO> localVarReturnType = new GenericType<MosaicsNamesDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public NamespaceInfoDTO getNamespace(String namespaceId) throws ApiException {
        return this.getNamespaceWithHttpInfo(namespaceId).getData();
    }

    public ApiResponse<NamespaceInfoDTO> getNamespaceWithHttpInfo(String namespaceId) throws ApiException {
        Object localVarPostBody = new Object();
        if (namespaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespace");
        }
        String localVarPath = "/namespace/{namespaceId}".replaceAll("\\{namespaceId\\}", this.apiClient.escapeString(namespaceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<NamespaceInfoDTO> localVarReturnType = new GenericType<NamespaceInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public NamespacesInfoDTO getNamespacesFromAccount(String accountId, Integer pageSize, String id) throws ApiException {
        return this.getNamespacesFromAccountWithHttpInfo(accountId, pageSize, id).getData();
    }

    public ApiResponse<NamespacesInfoDTO> getNamespacesFromAccountWithHttpInfo(String accountId, Integer pageSize, String id) throws ApiException {
        Object localVarPostBody = new Object();
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getNamespacesFromAccount");
        }
        String localVarPath = "/account/{accountId}/namespaces".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<NamespacesInfoDTO> localVarReturnType = new GenericType<NamespacesInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public NamespacesInfoDTO getNamespacesFromAccounts(AccountIds accountIds) throws ApiException {
        return this.getNamespacesFromAccountsWithHttpInfo(accountIds).getData();
    }

    public ApiResponse<NamespacesInfoDTO> getNamespacesFromAccountsWithHttpInfo(AccountIds accountIds) throws ApiException {
        AccountIds localVarPostBody = accountIds;
        String localVarPath = "/account/namespaces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<NamespacesInfoDTO> localVarReturnType = new GenericType<NamespacesInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<NamespaceNameDTO> getNamespacesNames(NamespaceIds namespaceIds) throws ApiException {
        return this.getNamespacesNamesWithHttpInfo(namespaceIds).getData();
    }

    public ApiResponse<List<NamespaceNameDTO>> getNamespacesNamesWithHttpInfo(NamespaceIds namespaceIds) throws ApiException {
        NamespaceIds localVarPostBody = namespaceIds;
        if (namespaceIds == null) {
            throw new ApiException(400, "Missing the required parameter 'namespaceIds' when calling getNamespacesNames");
        }
        String localVarPath = "/namespace/names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<NamespaceNameDTO>> localVarReturnType = new GenericType<List<NamespaceNameDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

