/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountIds;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicIds;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicsInfoDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class MosaicRoutesApi {
    private ApiClient apiClient;

    public MosaicRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MosaicRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MosaicInfoDTO getMosaic(String mosaicId) throws ApiException {
        return this.getMosaicWithHttpInfo(mosaicId).getData();
    }

    public ApiResponse<MosaicInfoDTO> getMosaicWithHttpInfo(String mosaicId) throws ApiException {
        Object localVarPostBody = new Object();
        if (mosaicId == null) {
            throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaic");
        }
        String localVarPath = "/mosaic/{mosaicId}".replaceAll("\\{mosaicId\\}", this.apiClient.escapeString(mosaicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MosaicInfoDTO> localVarReturnType = new GenericType<MosaicInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<MosaicInfoDTO> getMosaics(MosaicIds mosaicIds) throws ApiException {
        return this.getMosaicsWithHttpInfo(mosaicIds).getData();
    }

    public ApiResponse<List<MosaicInfoDTO>> getMosaicsWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
        MosaicIds localVarPostBody = mosaicIds;
        if (mosaicIds == null) {
            throw new ApiException(400, "Missing the required parameter 'mosaicIds' when calling getMosaics");
        }
        String localVarPath = "/mosaic";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<MosaicInfoDTO>> localVarReturnType = new GenericType<List<MosaicInfoDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MosaicsInfoDTO getMosaicsFromAccount(String accountId) throws ApiException {
        return this.getMosaicsFromAccountWithHttpInfo(accountId).getData();
    }

    public ApiResponse<MosaicsInfoDTO> getMosaicsFromAccountWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = new Object();
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getMosaicsFromAccount");
        }
        String localVarPath = "/account/{accountId}/mosaics".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MosaicsInfoDTO> localVarReturnType = new GenericType<MosaicsInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MosaicsInfoDTO getMosaicsFromAccounts(AccountIds accountIds) throws ApiException {
        return this.getMosaicsFromAccountsWithHttpInfo(accountIds).getData();
    }

    public ApiResponse<MosaicsInfoDTO> getMosaicsFromAccountsWithHttpInfo(AccountIds accountIds) throws ApiException {
        AccountIds localVarPostBody = accountIds;
        String localVarPath = "/account/mosaics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MosaicsInfoDTO> localVarReturnType = new GenericType<MosaicsInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

