/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"minRemovalDelta", "minApprovalDelta", "publicKeyAdditions", "publicKeyDeletions"})
public class MultisigAccountModificationTransactionBodyDTO {
    public static final String JSON_PROPERTY_MIN_REMOVAL_DELTA = "minRemovalDelta";
    private Integer minRemovalDelta;
    public static final String JSON_PROPERTY_MIN_APPROVAL_DELTA = "minApprovalDelta";
    private Integer minApprovalDelta;
    public static final String JSON_PROPERTY_PUBLIC_KEY_ADDITIONS = "publicKeyAdditions";
    private List<String> publicKeyAdditions = new ArrayList<String>();
    public static final String JSON_PROPERTY_PUBLIC_KEY_DELETIONS = "publicKeyDeletions";
    private List<String> publicKeyDeletions = new ArrayList<String>();

    public MultisigAccountModificationTransactionBodyDTO minRemovalDelta(Integer minRemovalDelta) {
        this.minRemovalDelta = minRemovalDelta;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Number of signatures needed to remove a cosignatory. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
    @JsonProperty(value="minRemovalDelta")
    public Integer getMinRemovalDelta() {
        return this.minRemovalDelta;
    }

    public void setMinRemovalDelta(Integer minRemovalDelta) {
        this.minRemovalDelta = minRemovalDelta;
    }

    public MultisigAccountModificationTransactionBodyDTO minApprovalDelta(Integer minApprovalDelta) {
        this.minApprovalDelta = minApprovalDelta;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Number of signatures needed to approve a transaction. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
    @JsonProperty(value="minApprovalDelta")
    public Integer getMinApprovalDelta() {
        return this.minApprovalDelta;
    }

    public void setMinApprovalDelta(Integer minApprovalDelta) {
        this.minApprovalDelta = minApprovalDelta;
    }

    public MultisigAccountModificationTransactionBodyDTO publicKeyAdditions(List<String> publicKeyAdditions) {
        this.publicKeyAdditions = publicKeyAdditions;
        return this;
    }

    public MultisigAccountModificationTransactionBodyDTO addPublicKeyAdditionsItem(String publicKeyAdditionsItem) {
        this.publicKeyAdditions.add(publicKeyAdditionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of cosignatory accounts to add.")
    @JsonProperty(value="publicKeyAdditions")
    public List<String> getPublicKeyAdditions() {
        return this.publicKeyAdditions;
    }

    public void setPublicKeyAdditions(List<String> publicKeyAdditions) {
        this.publicKeyAdditions = publicKeyAdditions;
    }

    public MultisigAccountModificationTransactionBodyDTO publicKeyDeletions(List<String> publicKeyDeletions) {
        this.publicKeyDeletions = publicKeyDeletions;
        return this;
    }

    public MultisigAccountModificationTransactionBodyDTO addPublicKeyDeletionsItem(String publicKeyDeletionsItem) {
        this.publicKeyDeletions.add(publicKeyDeletionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of cosignatory accounts to delete.")
    @JsonProperty(value="publicKeyDeletions")
    public List<String> getPublicKeyDeletions() {
        return this.publicKeyDeletions;
    }

    public void setPublicKeyDeletions(List<String> publicKeyDeletions) {
        this.publicKeyDeletions = publicKeyDeletions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultisigAccountModificationTransactionBodyDTO multisigAccountModificationTransactionBodyDTO = (MultisigAccountModificationTransactionBodyDTO)o;
        return Objects.equals(this.minRemovalDelta, multisigAccountModificationTransactionBodyDTO.minRemovalDelta) && Objects.equals(this.minApprovalDelta, multisigAccountModificationTransactionBodyDTO.minApprovalDelta) && Objects.equals(this.publicKeyAdditions, multisigAccountModificationTransactionBodyDTO.publicKeyAdditions) && Objects.equals(this.publicKeyDeletions, multisigAccountModificationTransactionBodyDTO.publicKeyDeletions);
    }

    public int hashCode() {
        return Objects.hash(this.minRemovalDelta, this.minApprovalDelta, this.publicKeyAdditions, this.publicKeyDeletions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultisigAccountModificationTransactionBodyDTO {\n");
        sb.append("    minRemovalDelta: ").append(this.toIndentedString(this.minRemovalDelta)).append("\n");
        sb.append("    minApprovalDelta: ").append(this.toIndentedString(this.minApprovalDelta)).append("\n");
        sb.append("    publicKeyAdditions: ").append(this.toIndentedString(this.publicKeyAdditions)).append("\n");
        sb.append("    publicKeyDeletions: ").append(this.toIndentedString(this.publicKeyDeletions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

