/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.jersey2.model.AliasActionEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Transaction to link a namespace to a mosaic.")
@JsonPropertyOrder(value={"signature", "signerPublicKey", "version", "network", "type", "maxFee", "deadline", "namespaceId", "mosaicId", "aliasAction"})
public class MosaicAliasTransactionDTO {
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_NAMESPACE_ID = "namespaceId";
    private String namespaceId;
    public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
    private String mosaicId;
    public static final String JSON_PROPERTY_ALIAS_ACTION = "aliasAction";
    private AliasActionEnum aliasAction;

    public MosaicAliasTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    @JsonProperty(value="signature")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public MosaicAliasTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    @JsonProperty(value="signerPublicKey")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public MosaicAliasTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public MosaicAliasTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="network")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public MosaicAliasTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public MosaicAliasTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="maxFee")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public MosaicAliasTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    @JsonProperty(value="deadline")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public MosaicAliasTransactionDTO namespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Namespace identifier.")
    @JsonProperty(value="namespaceId")
    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public MosaicAliasTransactionDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Mosaic identifier.")
    @JsonProperty(value="mosaicId")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public MosaicAliasTransactionDTO aliasAction(AliasActionEnum aliasAction) {
        this.aliasAction = aliasAction;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="aliasAction")
    public AliasActionEnum getAliasAction() {
        return this.aliasAction;
    }

    public void setAliasAction(AliasActionEnum aliasAction) {
        this.aliasAction = aliasAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MosaicAliasTransactionDTO mosaicAliasTransactionDTO = (MosaicAliasTransactionDTO)o;
        return Objects.equals(this.signature, mosaicAliasTransactionDTO.signature) && Objects.equals(this.signerPublicKey, mosaicAliasTransactionDTO.signerPublicKey) && Objects.equals(this.version, mosaicAliasTransactionDTO.version) && Objects.equals((Object)this.network, (Object)mosaicAliasTransactionDTO.network) && Objects.equals(this.type, mosaicAliasTransactionDTO.type) && Objects.equals(this.maxFee, mosaicAliasTransactionDTO.maxFee) && Objects.equals(this.deadline, mosaicAliasTransactionDTO.deadline) && Objects.equals(this.namespaceId, mosaicAliasTransactionDTO.namespaceId) && Objects.equals(this.mosaicId, mosaicAliasTransactionDTO.mosaicId) && Objects.equals((Object)this.aliasAction, (Object)mosaicAliasTransactionDTO.aliasAction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.namespaceId, this.mosaicId, this.aliasAction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MosaicAliasTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    namespaceId: ").append(this.toIndentedString(this.namespaceId)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    aliasAction: ").append(this.toIndentedString((Object)this.aliasAction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

