/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"maxTransactionsPerAggregate", "maxCosignaturesPerAggregate", "enableStrictCosignatureCheck", "enableBondedAggregateSupport", "maxBondedTransactionLifetime"})
public class AggregateNetworkPropertiesDTO {
    public static final String JSON_PROPERTY_MAX_TRANSACTIONS_PER_AGGREGATE = "maxTransactionsPerAggregate";
    private String maxTransactionsPerAggregate;
    public static final String JSON_PROPERTY_MAX_COSIGNATURES_PER_AGGREGATE = "maxCosignaturesPerAggregate";
    private String maxCosignaturesPerAggregate;
    public static final String JSON_PROPERTY_ENABLE_STRICT_COSIGNATURE_CHECK = "enableStrictCosignatureCheck";
    private Boolean enableStrictCosignatureCheck;
    public static final String JSON_PROPERTY_ENABLE_BONDED_AGGREGATE_SUPPORT = "enableBondedAggregateSupport";
    private Boolean enableBondedAggregateSupport;
    public static final String JSON_PROPERTY_MAX_BONDED_TRANSACTION_LIFETIME = "maxBondedTransactionLifetime";
    private String maxBondedTransactionLifetime;

    public AggregateNetworkPropertiesDTO maxTransactionsPerAggregate(String maxTransactionsPerAggregate) {
        this.maxTransactionsPerAggregate = maxTransactionsPerAggregate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1'000", value="Maximum number of transactions per aggregate.")
    @JsonProperty(value="maxTransactionsPerAggregate")
    public String getMaxTransactionsPerAggregate() {
        return this.maxTransactionsPerAggregate;
    }

    public void setMaxTransactionsPerAggregate(String maxTransactionsPerAggregate) {
        this.maxTransactionsPerAggregate = maxTransactionsPerAggregate;
    }

    public AggregateNetworkPropertiesDTO maxCosignaturesPerAggregate(String maxCosignaturesPerAggregate) {
        this.maxCosignaturesPerAggregate = maxCosignaturesPerAggregate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="15", value="Maximum number of cosignatures per aggregate.")
    @JsonProperty(value="maxCosignaturesPerAggregate")
    public String getMaxCosignaturesPerAggregate() {
        return this.maxCosignaturesPerAggregate;
    }

    public void setMaxCosignaturesPerAggregate(String maxCosignaturesPerAggregate) {
        this.maxCosignaturesPerAggregate = maxCosignaturesPerAggregate;
    }

    public AggregateNetworkPropertiesDTO enableStrictCosignatureCheck(Boolean enableStrictCosignatureCheck) {
        this.enableStrictCosignatureCheck = enableStrictCosignatureCheck;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Set to true if cosignatures must exactly match component signers. Set to false if cosignatures should be validated externally.")
    @JsonProperty(value="enableStrictCosignatureCheck")
    public Boolean getEnableStrictCosignatureCheck() {
        return this.enableStrictCosignatureCheck;
    }

    public void setEnableStrictCosignatureCheck(Boolean enableStrictCosignatureCheck) {
        this.enableStrictCosignatureCheck = enableStrictCosignatureCheck;
    }

    public AggregateNetworkPropertiesDTO enableBondedAggregateSupport(Boolean enableBondedAggregateSupport) {
        this.enableBondedAggregateSupport = enableBondedAggregateSupport;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Set to true if bonded aggregates should be allowed. Set to false if bonded aggregates should be rejected.")
    @JsonProperty(value="enableBondedAggregateSupport")
    public Boolean getEnableBondedAggregateSupport() {
        return this.enableBondedAggregateSupport;
    }

    public void setEnableBondedAggregateSupport(Boolean enableBondedAggregateSupport) {
        this.enableBondedAggregateSupport = enableBondedAggregateSupport;
    }

    public AggregateNetworkPropertiesDTO maxBondedTransactionLifetime(String maxBondedTransactionLifetime) {
        this.maxBondedTransactionLifetime = maxBondedTransactionLifetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="48h", value="Maximum lifetime a bonded transaction can have before it expires.")
    @JsonProperty(value="maxBondedTransactionLifetime")
    public String getMaxBondedTransactionLifetime() {
        return this.maxBondedTransactionLifetime;
    }

    public void setMaxBondedTransactionLifetime(String maxBondedTransactionLifetime) {
        this.maxBondedTransactionLifetime = maxBondedTransactionLifetime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateNetworkPropertiesDTO aggregateNetworkPropertiesDTO = (AggregateNetworkPropertiesDTO)o;
        return Objects.equals(this.maxTransactionsPerAggregate, aggregateNetworkPropertiesDTO.maxTransactionsPerAggregate) && Objects.equals(this.maxCosignaturesPerAggregate, aggregateNetworkPropertiesDTO.maxCosignaturesPerAggregate) && Objects.equals(this.enableStrictCosignatureCheck, aggregateNetworkPropertiesDTO.enableStrictCosignatureCheck) && Objects.equals(this.enableBondedAggregateSupport, aggregateNetworkPropertiesDTO.enableBondedAggregateSupport) && Objects.equals(this.maxBondedTransactionLifetime, aggregateNetworkPropertiesDTO.maxBondedTransactionLifetime);
    }

    public int hashCode() {
        return Objects.hash(this.maxTransactionsPerAggregate, this.maxCosignaturesPerAggregate, this.enableStrictCosignatureCheck, this.enableBondedAggregateSupport, this.maxBondedTransactionLifetime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AggregateNetworkPropertiesDTO {\n");
        sb.append("    maxTransactionsPerAggregate: ").append(this.toIndentedString(this.maxTransactionsPerAggregate)).append("\n");
        sb.append("    maxCosignaturesPerAggregate: ").append(this.toIndentedString(this.maxCosignaturesPerAggregate)).append("\n");
        sb.append("    enableStrictCosignatureCheck: ").append(this.toIndentedString(this.enableStrictCosignatureCheck)).append("\n");
        sb.append("    enableBondedAggregateSupport: ").append(this.toIndentedString(this.enableBondedAggregateSupport)).append("\n");
        sb.append("    maxBondedTransactionLifetime: ").append(this.toIndentedString(this.maxBondedTransactionLifetime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

