/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.jersey2.model.NodeIdentityEqualityStrategy;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Network related configuration properties.")
@JsonPropertyOrder(value={"identifier", "nodeEqualityStrategy", "publicKey", "generationHashSeed", "epochAdjustment"})
public class NetworkPropertiesDTO {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_NODE_EQUALITY_STRATEGY = "nodeEqualityStrategy";
    private NodeIdentityEqualityStrategy nodeEqualityStrategy;
    public static final String JSON_PROPERTY_PUBLIC_KEY = "publicKey";
    private String publicKey;
    public static final String JSON_PROPERTY_GENERATION_HASH_SEED = "generationHashSeed";
    private String generationHashSeed;
    public static final String JSON_PROPERTY_EPOCH_ADJUSTMENT = "epochAdjustment";
    private String epochAdjustment;

    public NetworkPropertiesDTO identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="mijin-test", value="Network identifier.")
    @JsonProperty(value="identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public NetworkPropertiesDTO nodeEqualityStrategy(NodeIdentityEqualityStrategy nodeEqualityStrategy) {
        this.nodeEqualityStrategy = nodeEqualityStrategy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="nodeEqualityStrategy")
    public NodeIdentityEqualityStrategy getNodeEqualityStrategy() {
        return this.nodeEqualityStrategy;
    }

    public void setNodeEqualityStrategy(NodeIdentityEqualityStrategy nodeEqualityStrategy) {
        this.nodeEqualityStrategy = nodeEqualityStrategy;
    }

    public NetworkPropertiesDTO publicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", value="Public key.")
    @JsonProperty(value="publicKey")
    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public NetworkPropertiesDTO generationHashSeed(String generationHashSeed) {
        this.generationHashSeed = generationHashSeed;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", value="")
    @JsonProperty(value="generationHashSeed")
    public String getGenerationHashSeed() {
        return this.generationHashSeed;
    }

    public void setGenerationHashSeed(String generationHashSeed) {
        this.generationHashSeed = generationHashSeed;
    }

    public NetworkPropertiesDTO epochAdjustment(String epochAdjustment) {
        this.epochAdjustment = epochAdjustment;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1573430400s", value="Nemesis epoch time adjustment.")
    @JsonProperty(value="epochAdjustment")
    public String getEpochAdjustment() {
        return this.epochAdjustment;
    }

    public void setEpochAdjustment(String epochAdjustment) {
        this.epochAdjustment = epochAdjustment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkPropertiesDTO networkPropertiesDTO = (NetworkPropertiesDTO)o;
        return Objects.equals(this.identifier, networkPropertiesDTO.identifier) && Objects.equals((Object)this.nodeEqualityStrategy, (Object)networkPropertiesDTO.nodeEqualityStrategy) && Objects.equals(this.publicKey, networkPropertiesDTO.publicKey) && Objects.equals(this.generationHashSeed, networkPropertiesDTO.generationHashSeed) && Objects.equals(this.epochAdjustment, networkPropertiesDTO.epochAdjustment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.nodeEqualityStrategy, this.publicKey, this.generationHashSeed, this.epochAdjustment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkPropertiesDTO {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    nodeEqualityStrategy: ").append(this.toIndentedString((Object)this.nodeEqualityStrategy)).append("\n");
        sb.append("    publicKey: ").append(this.toIndentedString(this.publicKey)).append("\n");
        sb.append("    generationHashSeed: ").append(this.toIndentedString(this.generationHashSeed)).append("\n");
        sb.append("    epochAdjustment: ").append(this.toIndentedString(this.epochAdjustment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

