/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;
import io.nem.symbol.sdk.openapi.jersey2.model.MerkleProofInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.StatementsDTO;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class ReceiptRoutesApi {
    private ApiClient apiClient;

    public ReceiptRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReceiptRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public StatementsDTO getBlockReceipts(BigInteger height) throws ApiException {
        return this.getBlockReceiptsWithHttpInfo(height).getData();
    }

    public ApiResponse<StatementsDTO> getBlockReceiptsWithHttpInfo(BigInteger height) throws ApiException {
        Object localVarPostBody = null;
        if (height == null) {
            throw new ApiException(400, "Missing the required parameter 'height' when calling getBlockReceipts");
        }
        String localVarPath = "/block/{height}/receipts".replaceAll("\\{height\\}", this.apiClient.escapeString(height.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<StatementsDTO> localVarReturnType = new GenericType<StatementsDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MerkleProofInfoDTO getMerkleReceipts(BigInteger height, String hash) throws ApiException {
        return this.getMerkleReceiptsWithHttpInfo(height, hash).getData();
    }

    public ApiResponse<MerkleProofInfoDTO> getMerkleReceiptsWithHttpInfo(BigInteger height, String hash) throws ApiException {
        Object localVarPostBody = null;
        if (height == null) {
            throw new ApiException(400, "Missing the required parameter 'height' when calling getMerkleReceipts");
        }
        if (hash == null) {
            throw new ApiException(400, "Missing the required parameter 'hash' when calling getMerkleReceipts");
        }
        String localVarPath = "/block/{height}/receipt/{hash}/merkle".replaceAll("\\{height\\}", this.apiClient.escapeString(height.toString())).replaceAll("\\{hash\\}", this.apiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MerkleProofInfoDTO> localVarReturnType = new GenericType<MerkleProofInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

