/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.jersey2.model.LockHashAlgorithmEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Transaction to sends mosaics to a recipient if the proof used is revealed. If the duration is reached, the locked funds go back to the sender of the transaction.")
@JsonPropertyOrder(value={"size", "signature", "signerPublicKey", "version", "network", "type", "maxFee", "deadline", "recipientAddress", "secret", "mosaicId", "amount", "duration", "hashAlgorithm"})
public class SecretLockTransactionDTO {
    public static final String JSON_PROPERTY_SIZE = "size";
    private Long size;
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
    private String recipientAddress;
    public static final String JSON_PROPERTY_SECRET = "secret";
    private String secret;
    public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
    private String mosaicId;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private BigInteger amount = null;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private BigInteger duration = null;
    public static final String JSON_PROPERTY_HASH_ALGORITHM = "hashAlgorithm";
    private LockHashAlgorithmEnum hashAlgorithm;

    public SecretLockTransactionDTO size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(example="2222212828", required=true, value="A number that allows uint 32 values.")
    @JsonProperty(value="size")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public SecretLockTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    @JsonProperty(value="signature")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public SecretLockTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    @JsonProperty(value="signerPublicKey")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public SecretLockTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public SecretLockTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="network")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public SecretLockTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public SecretLockTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="maxFee")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public SecretLockTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    @JsonProperty(value="deadline")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public SecretLockTransactionDTO recipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
        return this;
    }

    @ApiModelProperty(example="90340017CFF3DD2BCF3B2670CDCB9FC8C75754E2325F297C", required=true, value="Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
    @JsonProperty(value="recipientAddress")
    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public SecretLockTransactionDTO secret(String secret) {
        this.secret = secret;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="secret")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SecretLockTransactionDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
    @JsonProperty(value="mosaicId")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public SecretLockTransactionDTO amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="amount")
    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public SecretLockTransactionDTO duration(BigInteger duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    @JsonProperty(value="duration")
    public BigInteger getDuration() {
        return this.duration;
    }

    public void setDuration(BigInteger duration) {
        this.duration = duration;
    }

    public SecretLockTransactionDTO hashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="hashAlgorithm")
    public LockHashAlgorithmEnum getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretLockTransactionDTO secretLockTransactionDTO = (SecretLockTransactionDTO)o;
        return Objects.equals(this.size, secretLockTransactionDTO.size) && Objects.equals(this.signature, secretLockTransactionDTO.signature) && Objects.equals(this.signerPublicKey, secretLockTransactionDTO.signerPublicKey) && Objects.equals(this.version, secretLockTransactionDTO.version) && Objects.equals((Object)this.network, (Object)secretLockTransactionDTO.network) && Objects.equals(this.type, secretLockTransactionDTO.type) && Objects.equals(this.maxFee, secretLockTransactionDTO.maxFee) && Objects.equals(this.deadline, secretLockTransactionDTO.deadline) && Objects.equals(this.recipientAddress, secretLockTransactionDTO.recipientAddress) && Objects.equals(this.secret, secretLockTransactionDTO.secret) && Objects.equals(this.mosaicId, secretLockTransactionDTO.mosaicId) && Objects.equals(this.amount, secretLockTransactionDTO.amount) && Objects.equals(this.duration, secretLockTransactionDTO.duration) && Objects.equals((Object)this.hashAlgorithm, (Object)secretLockTransactionDTO.hashAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.recipientAddress, this.secret, this.mosaicId, this.amount, this.duration, this.hashAlgorithm});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecretLockTransactionDTO {\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    recipientAddress: ").append(this.toIndentedString(this.recipientAddress)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    hashAlgorithm: ").append(this.toIndentedString((Object)this.hashAlgorithm)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

