/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.UnresolvedMosaic;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"signerPublicKey", "version", "network", "type", "recipientAddress", "mosaics", "message"})
public class EmbeddedTransferTransactionDTO {
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    private Integer type;
    public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
    private String recipientAddress;
    public static final String JSON_PROPERTY_MOSAICS = "mosaics";
    private List<UnresolvedMosaic> mosaics = new ArrayList<UnresolvedMosaic>();
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;

    public EmbeddedTransferTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    @JsonProperty(value="signerPublicKey")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public EmbeddedTransferTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public EmbeddedTransferTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="network")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public EmbeddedTransferTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public EmbeddedTransferTransactionDTO recipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
        return this;
    }

    @ApiModelProperty(example="90340017CFF3DD2BCF3B2670CDCB9FC8C75754E2325F297C", required=true, value="Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
    @JsonProperty(value="recipientAddress")
    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public EmbeddedTransferTransactionDTO mosaics(List<UnresolvedMosaic> mosaics) {
        this.mosaics = mosaics;
        return this;
    }

    public EmbeddedTransferTransactionDTO addMosaicsItem(UnresolvedMosaic mosaicsItem) {
        this.mosaics.add(mosaicsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of mosaics sent to the recipient. ")
    @JsonProperty(value="mosaics")
    public List<UnresolvedMosaic> getMosaics() {
        return this.mosaics;
    }

    public void setMosaics(List<UnresolvedMosaic> mosaics) {
        this.mosaics = mosaics;
    }

    public EmbeddedTransferTransactionDTO message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Transfer transaction message")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddedTransferTransactionDTO embeddedTransferTransactionDTO = (EmbeddedTransferTransactionDTO)o;
        return Objects.equals(this.signerPublicKey, embeddedTransferTransactionDTO.signerPublicKey) && Objects.equals(this.version, embeddedTransferTransactionDTO.version) && Objects.equals((Object)this.network, (Object)embeddedTransferTransactionDTO.network) && Objects.equals(this.type, embeddedTransferTransactionDTO.type) && Objects.equals(this.recipientAddress, embeddedTransferTransactionDTO.recipientAddress) && Objects.equals(this.mosaics, embeddedTransferTransactionDTO.mosaics) && Objects.equals(this.message, embeddedTransferTransactionDTO.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signerPublicKey, this.version, this.network, this.type, this.recipientAddress, this.mosaics, this.message});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmbeddedTransferTransactionDTO {\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    recipientAddress: ").append(this.toIndentedString(this.recipientAddress)).append("\n");
        sb.append("    mosaics: ").append(this.toIndentedString(this.mosaics)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

