/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@JsonPropertyOrder(value={"size", "signature", "signerPublicKey", "version", "network", "type", "height", "timestamp", "difficulty", "proofGamma", "proofVerificationHash", "proofScalar", "previousBlockHash", "transactionsHash", "receiptsHash", "stateHash", "beneficiaryAddress", "feeMultiplier"})
public class BlockDTO {
    public static final String JSON_PROPERTY_SIZE = "size";
    private Long size;
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    private Integer type;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private BigInteger height = null;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private BigInteger timestamp = null;
    public static final String JSON_PROPERTY_DIFFICULTY = "difficulty";
    private BigInteger difficulty = null;
    public static final String JSON_PROPERTY_PROOF_GAMMA = "proofGamma";
    private String proofGamma;
    public static final String JSON_PROPERTY_PROOF_VERIFICATION_HASH = "proofVerificationHash";
    private String proofVerificationHash;
    public static final String JSON_PROPERTY_PROOF_SCALAR = "proofScalar";
    private String proofScalar;
    public static final String JSON_PROPERTY_PREVIOUS_BLOCK_HASH = "previousBlockHash";
    private String previousBlockHash;
    public static final String JSON_PROPERTY_TRANSACTIONS_HASH = "transactionsHash";
    private String transactionsHash;
    public static final String JSON_PROPERTY_RECEIPTS_HASH = "receiptsHash";
    private String receiptsHash;
    public static final String JSON_PROPERTY_STATE_HASH = "stateHash";
    private String stateHash;
    public static final String JSON_PROPERTY_BENEFICIARY_ADDRESS = "beneficiaryAddress";
    private String beneficiaryAddress;
    public static final String JSON_PROPERTY_FEE_MULTIPLIER = "feeMultiplier";
    private Long feeMultiplier;

    public BlockDTO size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(example="2222212828", required=true, value="A number that allows uint 32 values.")
    @JsonProperty(value="size")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public BlockDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    @JsonProperty(value="signature")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public BlockDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    @JsonProperty(value="signerPublicKey")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public BlockDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public BlockDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="network")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public BlockDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BlockDTO height(BigInteger height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Height of the blockchain.")
    @JsonProperty(value="height")
    public BigInteger getHeight() {
        return this.height;
    }

    public void setHeight(BigInteger height) {
        this.height = height;
    }

    public BlockDTO timestamp(BigInteger timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="timestamp")
    public BigInteger getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(BigInteger timestamp) {
        this.timestamp = timestamp;
    }

    public BlockDTO difficulty(BigInteger difficulty) {
        this.difficulty = difficulty;
        return this;
    }

    @ApiModelProperty(example="100000000000000", required=true, value="Determines how hard is to harvest a new block, based on previous blocks.")
    @JsonProperty(value="difficulty")
    public BigInteger getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(BigInteger difficulty) {
        this.difficulty = difficulty;
    }

    public BlockDTO proofGamma(String proofGamma) {
        this.proofGamma = proofGamma;
        return this;
    }

    @ApiModelProperty(example="8D49594A96C31EC6C64305FB2CCB47AA7A4AC0A4F614442BB3684D2BF41F274E", required=true, value="32-bytes VRF proof gamma.")
    @JsonProperty(value="proofGamma")
    public String getProofGamma() {
        return this.proofGamma;
    }

    public void setProofGamma(String proofGamma) {
        this.proofGamma = proofGamma;
    }

    public BlockDTO proofVerificationHash(String proofVerificationHash) {
        this.proofVerificationHash = proofVerificationHash;
        return this;
    }

    @ApiModelProperty(example="82FB583BFE3EE78805784D078F2547AE", required=true, value="16-bytes VRF proof verification hash.")
    @JsonProperty(value="proofVerificationHash")
    public String getProofVerificationHash() {
        return this.proofVerificationHash;
    }

    public void setProofVerificationHash(String proofVerificationHash) {
        this.proofVerificationHash = proofVerificationHash;
    }

    public BlockDTO proofScalar(String proofScalar) {
        this.proofScalar = proofScalar;
        return this;
    }

    @ApiModelProperty(example="480175C83739B22C53EAECAA7E7F3B245F1DFAFA6B3AE5C1D0129502FCBAAD0C", required=true, value="32-bytes VRF proof scalar.")
    @JsonProperty(value="proofScalar")
    public String getProofScalar() {
        return this.proofScalar;
    }

    public void setProofScalar(String proofScalar) {
        this.proofScalar = proofScalar;
    }

    public BlockDTO previousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="previousBlockHash")
    public String getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    public void setPreviousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
    }

    public BlockDTO transactionsHash(String transactionsHash) {
        this.transactionsHash = transactionsHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="transactionsHash")
    public String getTransactionsHash() {
        return this.transactionsHash;
    }

    public void setTransactionsHash(String transactionsHash) {
        this.transactionsHash = transactionsHash;
    }

    public BlockDTO receiptsHash(String receiptsHash) {
        this.receiptsHash = receiptsHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="receiptsHash")
    public String getReceiptsHash() {
        return this.receiptsHash;
    }

    public void setReceiptsHash(String receiptsHash) {
        this.receiptsHash = receiptsHash;
    }

    public BlockDTO stateHash(String stateHash) {
        this.stateHash = stateHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="stateHash")
    public String getStateHash() {
        return this.stateHash;
    }

    public void setStateHash(String stateHash) {
        this.stateHash = stateHash;
    }

    public BlockDTO beneficiaryAddress(String beneficiaryAddress) {
        this.beneficiaryAddress = beneficiaryAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required=true, value="Address expressed in hexadecimal base.")
    @JsonProperty(value="beneficiaryAddress")
    public String getBeneficiaryAddress() {
        return this.beneficiaryAddress;
    }

    public void setBeneficiaryAddress(String beneficiaryAddress) {
        this.beneficiaryAddress = beneficiaryAddress;
    }

    public BlockDTO feeMultiplier(Long feeMultiplier) {
        this.feeMultiplier = feeMultiplier;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Fee multiplier applied to transactions contained in block.")
    @JsonProperty(value="feeMultiplier")
    public Long getFeeMultiplier() {
        return this.feeMultiplier;
    }

    public void setFeeMultiplier(Long feeMultiplier) {
        this.feeMultiplier = feeMultiplier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockDTO blockDTO = (BlockDTO)o;
        return Objects.equals(this.size, blockDTO.size) && Objects.equals(this.signature, blockDTO.signature) && Objects.equals(this.signerPublicKey, blockDTO.signerPublicKey) && Objects.equals(this.version, blockDTO.version) && Objects.equals((Object)this.network, (Object)blockDTO.network) && Objects.equals(this.type, blockDTO.type) && Objects.equals(this.height, blockDTO.height) && Objects.equals(this.timestamp, blockDTO.timestamp) && Objects.equals(this.difficulty, blockDTO.difficulty) && Objects.equals(this.proofGamma, blockDTO.proofGamma) && Objects.equals(this.proofVerificationHash, blockDTO.proofVerificationHash) && Objects.equals(this.proofScalar, blockDTO.proofScalar) && Objects.equals(this.previousBlockHash, blockDTO.previousBlockHash) && Objects.equals(this.transactionsHash, blockDTO.transactionsHash) && Objects.equals(this.receiptsHash, blockDTO.receiptsHash) && Objects.equals(this.stateHash, blockDTO.stateHash) && Objects.equals(this.beneficiaryAddress, blockDTO.beneficiaryAddress) && Objects.equals(this.feeMultiplier, blockDTO.feeMultiplier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.signature, this.signerPublicKey, this.version, this.network, this.type, this.height, this.timestamp, this.difficulty, this.proofGamma, this.proofVerificationHash, this.proofScalar, this.previousBlockHash, this.transactionsHash, this.receiptsHash, this.stateHash, this.beneficiaryAddress, this.feeMultiplier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BlockDTO {\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    difficulty: ").append(this.toIndentedString(this.difficulty)).append("\n");
        sb.append("    proofGamma: ").append(this.toIndentedString(this.proofGamma)).append("\n");
        sb.append("    proofVerificationHash: ").append(this.toIndentedString(this.proofVerificationHash)).append("\n");
        sb.append("    proofScalar: ").append(this.toIndentedString(this.proofScalar)).append("\n");
        sb.append("    previousBlockHash: ").append(this.toIndentedString(this.previousBlockHash)).append("\n");
        sb.append("    transactionsHash: ").append(this.toIndentedString(this.transactionsHash)).append("\n");
        sb.append("    receiptsHash: ").append(this.toIndentedString(this.receiptsHash)).append("\n");
        sb.append("    stateHash: ").append(this.toIndentedString(this.stateHash)).append("\n");
        sb.append("    beneficiaryAddress: ").append(this.toIndentedString(this.beneficiaryAddress)).append("\n");
        sb.append("    feeMultiplier: ").append(this.toIndentedString(this.feeMultiplier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

