/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.jersey2.model.ReceiptTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Receipt stored when a state change that triggered a mosaic transfer.")
@JsonPropertyOrder(value={"version", "type", "mosaicId", "amount", "senderAddress", "recipientAddress"})
public class BalanceTransferReceiptDTO {
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ReceiptTypeEnum type;
    public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
    private String mosaicId;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private BigInteger amount = null;
    public static final String JSON_PROPERTY_SENDER_ADDRESS = "senderAddress";
    private String senderAddress;
    public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
    private String recipientAddress;

    public BalanceTransferReceiptDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Version of the receipt.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public BalanceTransferReceiptDTO type(ReceiptTypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    public ReceiptTypeEnum getType() {
        return this.type;
    }

    public void setType(ReceiptTypeEnum type) {
        this.type = type;
    }

    public BalanceTransferReceiptDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Mosaic identifier.")
    @JsonProperty(value="mosaicId")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public BalanceTransferReceiptDTO amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="amount")
    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public BalanceTransferReceiptDTO senderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required=true, value="Address expressed in hexadecimal base.")
    @JsonProperty(value="senderAddress")
    public String getSenderAddress() {
        return this.senderAddress;
    }

    public void setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
    }

    public BalanceTransferReceiptDTO recipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required=true, value="Address expressed in hexadecimal base.")
    @JsonProperty(value="recipientAddress")
    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceTransferReceiptDTO balanceTransferReceiptDTO = (BalanceTransferReceiptDTO)o;
        return Objects.equals(this.version, balanceTransferReceiptDTO.version) && Objects.equals((Object)this.type, (Object)balanceTransferReceiptDTO.type) && Objects.equals(this.mosaicId, balanceTransferReceiptDTO.mosaicId) && Objects.equals(this.amount, balanceTransferReceiptDTO.amount) && Objects.equals(this.senderAddress, balanceTransferReceiptDTO.senderAddress) && Objects.equals(this.recipientAddress, balanceTransferReceiptDTO.recipientAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.type, this.mosaicId, this.amount, this.senderAddress, this.recipientAddress});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceTransferReceiptDTO {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    senderAddress: ").append(this.toIndentedString(this.senderAddress)).append("\n");
        sb.append("    recipientAddress: ").append(this.toIndentedString(this.recipientAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

