/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.jersey2.model.CosignatureDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.EmbeddedTransactionInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Transaction to combine multiple transactions together.")
@JsonPropertyOrder(value={"size", "signature", "signerPublicKey", "version", "network", "type", "maxFee", "deadline", "transactionsHash", "cosignatures", "transactions"})
public class AggregateTransactionExtendedDTO {
    public static final String JSON_PROPERTY_SIZE = "size";
    private Long size;
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_TRANSACTIONS_HASH = "transactionsHash";
    private String transactionsHash;
    public static final String JSON_PROPERTY_COSIGNATURES = "cosignatures";
    private List<CosignatureDTO> cosignatures = new ArrayList<CosignatureDTO>();
    public static final String JSON_PROPERTY_TRANSACTIONS = "transactions";
    private List<EmbeddedTransactionInfoDTO> transactions = new ArrayList<EmbeddedTransactionInfoDTO>();

    public AggregateTransactionExtendedDTO size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(example="2222212828", required=true, value="A number that allows uint 32 values.")
    @JsonProperty(value="size")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public AggregateTransactionExtendedDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    @JsonProperty(value="signature")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public AggregateTransactionExtendedDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    @JsonProperty(value="signerPublicKey")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public AggregateTransactionExtendedDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public AggregateTransactionExtendedDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="network")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public AggregateTransactionExtendedDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public AggregateTransactionExtendedDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="maxFee")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public AggregateTransactionExtendedDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    @JsonProperty(value="deadline")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public AggregateTransactionExtendedDTO transactionsHash(String transactionsHash) {
        this.transactionsHash = transactionsHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="transactionsHash")
    public String getTransactionsHash() {
        return this.transactionsHash;
    }

    public void setTransactionsHash(String transactionsHash) {
        this.transactionsHash = transactionsHash;
    }

    public AggregateTransactionExtendedDTO cosignatures(List<CosignatureDTO> cosignatures) {
        this.cosignatures = cosignatures;
        return this;
    }

    public AggregateTransactionExtendedDTO addCosignaturesItem(CosignatureDTO cosignaturesItem) {
        this.cosignatures.add(cosignaturesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of transaction cosignatures.")
    @JsonProperty(value="cosignatures")
    public List<CosignatureDTO> getCosignatures() {
        return this.cosignatures;
    }

    public void setCosignatures(List<CosignatureDTO> cosignatures) {
        this.cosignatures = cosignatures;
    }

    public AggregateTransactionExtendedDTO transactions(List<EmbeddedTransactionInfoDTO> transactions) {
        this.transactions = transactions;
        return this;
    }

    public AggregateTransactionExtendedDTO addTransactionsItem(EmbeddedTransactionInfoDTO transactionsItem) {
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of transactions initiated by different accounts.")
    @JsonProperty(value="transactions")
    public List<EmbeddedTransactionInfoDTO> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<EmbeddedTransactionInfoDTO> transactions) {
        this.transactions = transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateTransactionExtendedDTO aggregateTransactionExtendedDTO = (AggregateTransactionExtendedDTO)o;
        return Objects.equals(this.size, aggregateTransactionExtendedDTO.size) && Objects.equals(this.signature, aggregateTransactionExtendedDTO.signature) && Objects.equals(this.signerPublicKey, aggregateTransactionExtendedDTO.signerPublicKey) && Objects.equals(this.version, aggregateTransactionExtendedDTO.version) && Objects.equals((Object)this.network, (Object)aggregateTransactionExtendedDTO.network) && Objects.equals(this.type, aggregateTransactionExtendedDTO.type) && Objects.equals(this.maxFee, aggregateTransactionExtendedDTO.maxFee) && Objects.equals(this.deadline, aggregateTransactionExtendedDTO.deadline) && Objects.equals(this.transactionsHash, aggregateTransactionExtendedDTO.transactionsHash) && Objects.equals(this.cosignatures, aggregateTransactionExtendedDTO.cosignatures) && Objects.equals(this.transactions, aggregateTransactionExtendedDTO.transactions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.transactionsHash, this.cosignatures, this.transactions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AggregateTransactionExtendedDTO {\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    transactionsHash: ").append(this.toIndentedString(this.transactionsHash)).append("\n");
        sb.append("    cosignatures: ").append(this.toIndentedString(this.cosignatures)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

