/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Supplementary data stored for importance recalculation. At each importance recalculation, existing buckets are shifted, the working bucket is finalized and a new working bucket is created. Each bucket influences at most five importance recalculations. ")
@JsonPropertyOrder(value={"startHeight", "totalFeesPaid", "beneficiaryCount", "rawScore"})
public class ActivityBucketDTO {
    public static final String JSON_PROPERTY_START_HEIGHT = "startHeight";
    private BigInteger startHeight = null;
    public static final String JSON_PROPERTY_TOTAL_FEES_PAID = "totalFeesPaid";
    private BigInteger totalFeesPaid = null;
    public static final String JSON_PROPERTY_BENEFICIARY_COUNT = "beneficiaryCount";
    private Long beneficiaryCount;
    public static final String JSON_PROPERTY_RAW_SCORE = "rawScore";
    private BigInteger rawScore = null;

    public ActivityBucketDTO startHeight(BigInteger startHeight) {
        this.startHeight = startHeight;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Height of the blockchain.")
    @JsonProperty(value="startHeight")
    public BigInteger getStartHeight() {
        return this.startHeight;
    }

    public void setStartHeight(BigInteger startHeight) {
        this.startHeight = startHeight;
    }

    public ActivityBucketDTO totalFeesPaid(BigInteger totalFeesPaid) {
        this.totalFeesPaid = totalFeesPaid;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="totalFeesPaid")
    public BigInteger getTotalFeesPaid() {
        return this.totalFeesPaid;
    }

    public void setTotalFeesPaid(BigInteger totalFeesPaid) {
        this.totalFeesPaid = totalFeesPaid;
    }

    public ActivityBucketDTO beneficiaryCount(Long beneficiaryCount) {
        this.beneficiaryCount = beneficiaryCount;
        return this;
    }

    @ApiModelProperty(example="2222212828", required=true, value="A number that allows uint 32 values.")
    @JsonProperty(value="beneficiaryCount")
    public Long getBeneficiaryCount() {
        return this.beneficiaryCount;
    }

    public void setBeneficiaryCount(Long beneficiaryCount) {
        this.beneficiaryCount = beneficiaryCount;
    }

    public ActivityBucketDTO rawScore(BigInteger rawScore) {
        this.rawScore = rawScore;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Probability of an account to harvest the next block.")
    @JsonProperty(value="rawScore")
    public BigInteger getRawScore() {
        return this.rawScore;
    }

    public void setRawScore(BigInteger rawScore) {
        this.rawScore = rawScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityBucketDTO activityBucketDTO = (ActivityBucketDTO)o;
        return Objects.equals(this.startHeight, activityBucketDTO.startHeight) && Objects.equals(this.totalFeesPaid, activityBucketDTO.totalFeesPaid) && Objects.equals(this.beneficiaryCount, activityBucketDTO.beneficiaryCount) && Objects.equals(this.rawScore, activityBucketDTO.rawScore);
    }

    public int hashCode() {
        return Objects.hash(this.startHeight, this.totalFeesPaid, this.beneficiaryCount, this.rawScore);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityBucketDTO {\n");
        sb.append("    startHeight: ").append(this.toIndentedString(this.startHeight)).append("\n");
        sb.append("    totalFeesPaid: ").append(this.toIndentedString(this.totalFeesPaid)).append("\n");
        sb.append("    beneficiaryCount: ").append(this.toIndentedString(this.beneficiaryCount)).append("\n");
        sb.append("    rawScore: ").append(this.toIndentedString(this.rawScore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

