/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;
import io.nem.symbol.sdk.openapi.jersey2.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;
import io.nem.symbol.sdk.openapi.jersey2.model.SecretLockInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.SecretLockPage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class SecretLockRoutesApi {
    private ApiClient apiClient;

    public SecretLockRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SecretLockRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SecretLockInfoDTO getSecretLock(String compositeHash) throws ApiException {
        return this.getSecretLockWithHttpInfo(compositeHash).getData();
    }

    public ApiResponse<SecretLockInfoDTO> getSecretLockWithHttpInfo(String compositeHash) throws ApiException {
        Object localVarPostBody = null;
        if (compositeHash == null) {
            throw new ApiException(400, "Missing the required parameter 'compositeHash' when calling getSecretLock");
        }
        String localVarPath = "/lock/secret/{compositeHash}".replaceAll("\\{compositeHash\\}", this.apiClient.escapeString(compositeHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SecretLockInfoDTO> localVarReturnType = new GenericType<SecretLockInfoDTO>(){};
        return this.apiClient.invokeAPI("SecretLockRoutesApi.getSecretLock", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MerkleStateInfoDTO getSecretLockMerkle(String compositeHash) throws ApiException {
        return this.getSecretLockMerkleWithHttpInfo(compositeHash).getData();
    }

    public ApiResponse<MerkleStateInfoDTO> getSecretLockMerkleWithHttpInfo(String compositeHash) throws ApiException {
        Object localVarPostBody = null;
        if (compositeHash == null) {
            throw new ApiException(400, "Missing the required parameter 'compositeHash' when calling getSecretLockMerkle");
        }
        String localVarPath = "/lock/secret/{compositeHash}/merkle".replaceAll("\\{compositeHash\\}", this.apiClient.escapeString(compositeHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MerkleStateInfoDTO> localVarReturnType = new GenericType<MerkleStateInfoDTO>(){};
        return this.apiClient.invokeAPI("SecretLockRoutesApi.getSecretLockMerkle", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SecretLockPage searchSecretLock(String address, String secret, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
        return this.searchSecretLockWithHttpInfo(address, secret, pageSize, pageNumber, offset, order).getData();
    }

    public ApiResponse<SecretLockPage> searchSecretLockWithHttpInfo(String address, String secret, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lock/secret";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "address", address));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "secret", secret));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SecretLockPage> localVarReturnType = new GenericType<SecretLockPage>(){};
        return this.apiClient.invokeAPI("SecretLockRoutesApi.searchSecretLock", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

