/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountRestrictionsInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountRestrictionsPage;
import io.nem.symbol.sdk.openapi.jersey2.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class RestrictionAccountRoutesApi {
    private ApiClient apiClient;

    public RestrictionAccountRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RestrictionAccountRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AccountRestrictionsInfoDTO getAccountRestrictions(String address) throws ApiException {
        return this.getAccountRestrictionsWithHttpInfo(address).getData();
    }

    public ApiResponse<AccountRestrictionsInfoDTO> getAccountRestrictionsWithHttpInfo(String address) throws ApiException {
        Object localVarPostBody = null;
        if (address == null) {
            throw new ApiException(400, "Missing the required parameter 'address' when calling getAccountRestrictions");
        }
        String localVarPath = "/restrictions/account/{address}".replaceAll("\\{address\\}", this.apiClient.escapeString(address.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AccountRestrictionsInfoDTO> localVarReturnType = new GenericType<AccountRestrictionsInfoDTO>(){};
        return this.apiClient.invokeAPI("RestrictionAccountRoutesApi.getAccountRestrictions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MerkleStateInfoDTO getAccountRestrictionsMerkle(String address) throws ApiException {
        return this.getAccountRestrictionsMerkleWithHttpInfo(address).getData();
    }

    public ApiResponse<MerkleStateInfoDTO> getAccountRestrictionsMerkleWithHttpInfo(String address) throws ApiException {
        Object localVarPostBody = null;
        if (address == null) {
            throw new ApiException(400, "Missing the required parameter 'address' when calling getAccountRestrictionsMerkle");
        }
        String localVarPath = "/restrictions/account/{address}/merkle".replaceAll("\\{address\\}", this.apiClient.escapeString(address.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MerkleStateInfoDTO> localVarReturnType = new GenericType<MerkleStateInfoDTO>(){};
        return this.apiClient.invokeAPI("RestrictionAccountRoutesApi.getAccountRestrictionsMerkle", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AccountRestrictionsPage searchAccountRestrictions(String address, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
        return this.searchAccountRestrictionsWithHttpInfo(address, pageSize, pageNumber, offset, order).getData();
    }

    public ApiResponse<AccountRestrictionsPage> searchAccountRestrictionsWithHttpInfo(String address, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/restrictions/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "address", address));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AccountRestrictionsPage> localVarReturnType = new GenericType<AccountRestrictionsPage>(){};
        return this.apiClient.invokeAPI("RestrictionAccountRoutesApi.searchAccountRestrictions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

