/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;
import io.nem.symbol.sdk.openapi.jersey2.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.MetadataInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.MetadataPage;
import io.nem.symbol.sdk.openapi.jersey2.model.MetadataTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class MetadataRoutesApi {
    private ApiClient apiClient;

    public MetadataRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetadataRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MetadataInfoDTO getMetadata(String compositeHash) throws ApiException {
        return this.getMetadataWithHttpInfo(compositeHash).getData();
    }

    public ApiResponse<MetadataInfoDTO> getMetadataWithHttpInfo(String compositeHash) throws ApiException {
        Object localVarPostBody = null;
        if (compositeHash == null) {
            throw new ApiException(400, "Missing the required parameter 'compositeHash' when calling getMetadata");
        }
        String localVarPath = "/metadata/{compositeHash}".replaceAll("\\{compositeHash\\}", this.apiClient.escapeString(compositeHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MetadataInfoDTO> localVarReturnType = new GenericType<MetadataInfoDTO>(){};
        return this.apiClient.invokeAPI("MetadataRoutesApi.getMetadata", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MerkleStateInfoDTO getMetadataMerkle(String compositeHash) throws ApiException {
        return this.getMetadataMerkleWithHttpInfo(compositeHash).getData();
    }

    public ApiResponse<MerkleStateInfoDTO> getMetadataMerkleWithHttpInfo(String compositeHash) throws ApiException {
        Object localVarPostBody = null;
        if (compositeHash == null) {
            throw new ApiException(400, "Missing the required parameter 'compositeHash' when calling getMetadataMerkle");
        }
        String localVarPath = "/metadata/{compositeHash}/merkle".replaceAll("\\{compositeHash\\}", this.apiClient.escapeString(compositeHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MerkleStateInfoDTO> localVarReturnType = new GenericType<MerkleStateInfoDTO>(){};
        return this.apiClient.invokeAPI("MetadataRoutesApi.getMetadataMerkle", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MetadataPage searchMetadataEntries(String sourceAddress, String targetAddress, String scopedMetadataKey, String targetId, MetadataTypeEnum metadataType, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
        return this.searchMetadataEntriesWithHttpInfo(sourceAddress, targetAddress, scopedMetadataKey, targetId, metadataType, pageSize, pageNumber, offset, order).getData();
    }

    public ApiResponse<MetadataPage> searchMetadataEntriesWithHttpInfo(String sourceAddress, String targetAddress, String scopedMetadataKey, String targetId, MetadataTypeEnum metadataType, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/metadata";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sourceAddress", sourceAddress));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "targetAddress", targetAddress));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "scopedMetadataKey", scopedMetadataKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "targetId", targetId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "metadataType", (Object)metadataType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MetadataPage> localVarReturnType = new GenericType<MetadataPage>(){};
        return this.apiClient.invokeAPI("MetadataRoutesApi.searchMetadataEntries", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

