/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.2.0
 *
 * The version of the OpenAPI document: 0.10.5
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.jersey2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.jersey2.model.MerkleTreeNodeTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Merkle tree leaf node.
 */
@ApiModel(description = "Merkle tree leaf node.")
@JsonPropertyOrder({
  MerkleTreeLeafDTO.JSON_PROPERTY_TYPE,
  MerkleTreeLeafDTO.JSON_PROPERTY_PATH,
  MerkleTreeLeafDTO.JSON_PROPERTY_ENCODED_PATH,
  MerkleTreeLeafDTO.JSON_PROPERTY_NIBBLE_COUNT,
  MerkleTreeLeafDTO.JSON_PROPERTY_VALUE,
  MerkleTreeLeafDTO.JSON_PROPERTY_LEAF_HASH
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-10T22:06:29.886Z[UTC]")
public class MerkleTreeLeafDTO {
  public static final String JSON_PROPERTY_TYPE = "type";
  private MerkleTreeNodeTypeEnum type;

  public static final String JSON_PROPERTY_PATH = "path";
  private String path;

  public static final String JSON_PROPERTY_ENCODED_PATH = "encodedPath";
  private String encodedPath;

  public static final String JSON_PROPERTY_NIBBLE_COUNT = "nibbleCount";
  private Integer nibbleCount;

  public static final String JSON_PROPERTY_VALUE = "value";
  private String value;

  public static final String JSON_PROPERTY_LEAF_HASH = "leafHash";
  private String leafHash;


  public MerkleTreeLeafDTO type(MerkleTreeNodeTypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MerkleTreeNodeTypeEnum getType() {
    return type;
  }


  public void setType(MerkleTreeNodeTypeEnum type) {
    this.type = type;
  }


  public MerkleTreeLeafDTO path(String path) {
    
    this.path = path;
    return this;
  }

   /**
   * Leaf path.
   * @return path
  **/
  @ApiModelProperty(required = true, value = "Leaf path.")
  @JsonProperty(JSON_PROPERTY_PATH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPath() {
    return path;
  }


  public void setPath(String path) {
    this.path = path;
  }


  public MerkleTreeLeafDTO encodedPath(String encodedPath) {
    
    this.encodedPath = encodedPath;
    return this;
  }

   /**
   * Encoded leaf path.
   * @return encodedPath
  **/
  @ApiModelProperty(required = true, value = "Encoded leaf path.")
  @JsonProperty(JSON_PROPERTY_ENCODED_PATH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEncodedPath() {
    return encodedPath;
  }


  public void setEncodedPath(String encodedPath) {
    this.encodedPath = encodedPath;
  }


  public MerkleTreeLeafDTO nibbleCount(Integer nibbleCount) {
    
    this.nibbleCount = nibbleCount;
    return this;
  }

   /**
   * Nibble count.
   * @return nibbleCount
  **/
  @ApiModelProperty(required = true, value = "Nibble count.")
  @JsonProperty(JSON_PROPERTY_NIBBLE_COUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getNibbleCount() {
    return nibbleCount;
  }


  public void setNibbleCount(Integer nibbleCount) {
    this.nibbleCount = nibbleCount;
  }


  public MerkleTreeLeafDTO value(String value) {
    
    this.value = value;
    return this;
  }

   /**
   * Leaf value (sha256 hash).
   * @return value
  **/
  @ApiModelProperty(required = true, value = "Leaf value (sha256 hash).")
  @JsonProperty(JSON_PROPERTY_VALUE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getValue() {
    return value;
  }


  public void setValue(String value) {
    this.value = value;
  }


  public MerkleTreeLeafDTO leafHash(String leafHash) {
    
    this.leafHash = leafHash;
    return this;
  }

   /**
   * Get leafHash
   * @return leafHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_LEAF_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLeafHash() {
    return leafHash;
  }


  public void setLeafHash(String leafHash) {
    this.leafHash = leafHash;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerkleTreeLeafDTO merkleTreeLeafDTO = (MerkleTreeLeafDTO) o;
    return Objects.equals(this.type, merkleTreeLeafDTO.type) &&
        Objects.equals(this.path, merkleTreeLeafDTO.path) &&
        Objects.equals(this.encodedPath, merkleTreeLeafDTO.encodedPath) &&
        Objects.equals(this.nibbleCount, merkleTreeLeafDTO.nibbleCount) &&
        Objects.equals(this.value, merkleTreeLeafDTO.value) &&
        Objects.equals(this.leafHash, merkleTreeLeafDTO.leafHash);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, path, encodedPath, nibbleCount, value, leafHash);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerkleTreeLeafDTO {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    encodedPath: ").append(toIndentedString(encodedPath)).append("\n");
    sb.append("    nibbleCount: ").append(toIndentedString(nibbleCount)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    leafHash: ").append(toIndentedString(leafHash)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

