/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.2.0
 *
 * The version of the OpenAPI document: 0.10.5
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.jersey2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.jersey2.model.EmbeddedTransactionDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicMetadataTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * EmbeddedMosaicMetadataTransactionDTO
 */
@JsonPropertyOrder({
  EmbeddedMosaicMetadataTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  EmbeddedMosaicMetadataTransactionDTO.JSON_PROPERTY_VERSION,
  EmbeddedMosaicMetadataTransactionDTO.JSON_PROPERTY_NETWORK,
  EmbeddedMosaicMetadataTransactionDTO.JSON_PROPERTY_TYPE,
  EmbeddedMosaicMetadataTransactionDTO.JSON_PROPERTY_TARGET_ADDRESS,
  EmbeddedMosaicMetadataTransactionDTO.JSON_PROPERTY_SCOPED_METADATA_KEY,
  EmbeddedMosaicMetadataTransactionDTO.JSON_PROPERTY_TARGET_MOSAIC_ID,
  EmbeddedMosaicMetadataTransactionDTO.JSON_PROPERTY_VALUE_SIZE_DELTA,
  EmbeddedMosaicMetadataTransactionDTO.JSON_PROPERTY_VALUE_SIZE,
  EmbeddedMosaicMetadataTransactionDTO.JSON_PROPERTY_VALUE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-10T22:06:29.886Z[UTC]")
public class EmbeddedMosaicMetadataTransactionDTO {
  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_TARGET_ADDRESS = "targetAddress";
  private String targetAddress;

  public static final String JSON_PROPERTY_SCOPED_METADATA_KEY = "scopedMetadataKey";
  private String scopedMetadataKey;

  public static final String JSON_PROPERTY_TARGET_MOSAIC_ID = "targetMosaicId";
  private String targetMosaicId;

  public static final String JSON_PROPERTY_VALUE_SIZE_DELTA = "valueSizeDelta";
  private Integer valueSizeDelta;

  public static final String JSON_PROPERTY_VALUE_SIZE = "valueSize";
  private Long valueSize;

  public static final String JSON_PROPERTY_VALUE = "value";
  private String value;


  public EmbeddedMosaicMetadataTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public EmbeddedMosaicMetadataTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public EmbeddedMosaicMetadataTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public EmbeddedMosaicMetadataTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public EmbeddedMosaicMetadataTransactionDTO targetAddress(String targetAddress) {
    
    this.targetAddress = targetAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. 
   * @return targetAddress
  **/
  @ApiModelProperty(example = "90340017CFF3DD2BCF3B2670CDCB9FC8C75754E2325F297C", required = true, value = "Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
  @JsonProperty(JSON_PROPERTY_TARGET_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetAddress() {
    return targetAddress;
  }


  public void setTargetAddress(String targetAddress) {
    this.targetAddress = targetAddress;
  }


  public EmbeddedMosaicMetadataTransactionDTO scopedMetadataKey(String scopedMetadataKey) {
    
    this.scopedMetadataKey = scopedMetadataKey;
    return this;
  }

   /**
   * Metadata key scoped to source, target and type expressed.
   * @return scopedMetadataKey
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Metadata key scoped to source, target and type expressed.")
  @JsonProperty(JSON_PROPERTY_SCOPED_METADATA_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getScopedMetadataKey() {
    return scopedMetadataKey;
  }


  public void setScopedMetadataKey(String scopedMetadataKey) {
    this.scopedMetadataKey = scopedMetadataKey;
  }


  public EmbeddedMosaicMetadataTransactionDTO targetMosaicId(String targetMosaicId) {
    
    this.targetMosaicId = targetMosaicId;
    return this;
  }

   /**
   * Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. 
   * @return targetMosaicId
  **/
  @ApiModelProperty(example = "85BBEA6CC462B244", required = true, value = "Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
  @JsonProperty(JSON_PROPERTY_TARGET_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetMosaicId() {
    return targetMosaicId;
  }


  public void setTargetMosaicId(String targetMosaicId) {
    this.targetMosaicId = targetMosaicId;
  }


  public EmbeddedMosaicMetadataTransactionDTO valueSizeDelta(Integer valueSizeDelta) {
    
    this.valueSizeDelta = valueSizeDelta;
    return this;
  }

   /**
   * Change in value size in bytes.
   * @return valueSizeDelta
  **/
  @ApiModelProperty(required = true, value = "Change in value size in bytes.")
  @JsonProperty(JSON_PROPERTY_VALUE_SIZE_DELTA)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getValueSizeDelta() {
    return valueSizeDelta;
  }


  public void setValueSizeDelta(Integer valueSizeDelta) {
    this.valueSizeDelta = valueSizeDelta;
  }


  public EmbeddedMosaicMetadataTransactionDTO valueSize(Long valueSize) {
    
    this.valueSize = valueSize;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return valueSize
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_VALUE_SIZE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getValueSize() {
    return valueSize;
  }


  public void setValueSize(Long valueSize) {
    this.valueSize = valueSize;
  }


  public EmbeddedMosaicMetadataTransactionDTO value(String value) {
    
    this.value = value;
    return this;
  }

   /**
   * Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).
   * @return value
  **/
  @ApiModelProperty(required = true, value = "Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).")
  @JsonProperty(JSON_PROPERTY_VALUE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getValue() {
    return value;
  }


  public void setValue(String value) {
    this.value = value;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EmbeddedMosaicMetadataTransactionDTO embeddedMosaicMetadataTransactionDTO = (EmbeddedMosaicMetadataTransactionDTO) o;
    return Objects.equals(this.signerPublicKey, embeddedMosaicMetadataTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, embeddedMosaicMetadataTransactionDTO.version) &&
        Objects.equals(this.network, embeddedMosaicMetadataTransactionDTO.network) &&
        Objects.equals(this.type, embeddedMosaicMetadataTransactionDTO.type) &&
        Objects.equals(this.targetAddress, embeddedMosaicMetadataTransactionDTO.targetAddress) &&
        Objects.equals(this.scopedMetadataKey, embeddedMosaicMetadataTransactionDTO.scopedMetadataKey) &&
        Objects.equals(this.targetMosaicId, embeddedMosaicMetadataTransactionDTO.targetMosaicId) &&
        Objects.equals(this.valueSizeDelta, embeddedMosaicMetadataTransactionDTO.valueSizeDelta) &&
        Objects.equals(this.valueSize, embeddedMosaicMetadataTransactionDTO.valueSize) &&
        Objects.equals(this.value, embeddedMosaicMetadataTransactionDTO.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signerPublicKey, version, network, type, targetAddress, scopedMetadataKey, targetMosaicId, valueSizeDelta, valueSize, value);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddedMosaicMetadataTransactionDTO {\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    targetAddress: ").append(toIndentedString(targetAddress)).append("\n");
    sb.append("    scopedMetadataKey: ").append(toIndentedString(scopedMetadataKey)).append("\n");
    sb.append("    targetMosaicId: ").append(toIndentedString(targetMosaicId)).append("\n");
    sb.append("    valueSizeDelta: ").append(toIndentedString(valueSizeDelta)).append("\n");
    sb.append("    valueSize: ").append(toIndentedString(valueSize)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

