package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicRestrictionEntryTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicRestrictionsPage;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-10T22:06:29.886Z[UTC]")
public class RestrictionMosaicRoutesApi {
  private ApiClient apiClient;

  public RestrictionMosaicRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public RestrictionMosaicRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Get the mosaic restrictions
   * Returns the mosaic restrictions for a composite hash.
   * @param compositeHash Filter by composite hash. (required)
   * @return Object
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public Object getMosaicRestrictions(String compositeHash) throws ApiException {
    return getMosaicRestrictionsWithHttpInfo(compositeHash).getData();
  }

  /**
   * Get the mosaic restrictions
   * Returns the mosaic restrictions for a composite hash.
   * @param compositeHash Filter by composite hash. (required)
   * @return ApiResponse&lt;Object&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<Object> getMosaicRestrictionsWithHttpInfo(String compositeHash) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'compositeHash' is set
    if (compositeHash == null) {
      throw new ApiException(400, "Missing the required parameter 'compositeHash' when calling getMosaicRestrictions");
    }
    
    // create path and map variables
    String localVarPath = "/restrictions/mosaic/{compositeHash}"
      .replaceAll("\\{" + "compositeHash" + "\\}", apiClient.escapeString(compositeHash.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Object> localVarReturnType = new GenericType<Object>() {};
    return apiClient.invokeAPI("RestrictionMosaicRoutesApi.getMosaicRestrictions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get the mosaic restrictions merkle
   * Returns the mosaic restrictions merkle for a given composite hash.
   * @param compositeHash Filter by composite hash. (required)
   * @return MerkleStateInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MerkleStateInfoDTO getMosaicRestrictionsMerkle(String compositeHash) throws ApiException {
    return getMosaicRestrictionsMerkleWithHttpInfo(compositeHash).getData();
  }

  /**
   * Get the mosaic restrictions merkle
   * Returns the mosaic restrictions merkle for a given composite hash.
   * @param compositeHash Filter by composite hash. (required)
   * @return ApiResponse&lt;MerkleStateInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MerkleStateInfoDTO> getMosaicRestrictionsMerkleWithHttpInfo(String compositeHash) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'compositeHash' is set
    if (compositeHash == null) {
      throw new ApiException(400, "Missing the required parameter 'compositeHash' when calling getMosaicRestrictionsMerkle");
    }
    
    // create path and map variables
    String localVarPath = "/restrictions/mosaic/{compositeHash}/merkle"
      .replaceAll("\\{" + "compositeHash" + "\\}", apiClient.escapeString(compositeHash.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MerkleStateInfoDTO> localVarReturnType = new GenericType<MerkleStateInfoDTO>() {};
    return apiClient.invokeAPI("RestrictionMosaicRoutesApi.getMosaicRestrictionsMerkle", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Search mosaic restrictions
   * Returns an array of mosaic restrictions.
   * @param mosaicId Filter by mosaic identifier. (optional)
   * @param entryType Filter by entry type. (optional)
   * @param targetAddress Filter by target address. (optional)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return MosaicRestrictionsPage
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MosaicRestrictionsPage searchMosaicRestrictions(String mosaicId, MosaicRestrictionEntryTypeEnum entryType, String targetAddress, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    return searchMosaicRestrictionsWithHttpInfo(mosaicId, entryType, targetAddress, pageSize, pageNumber, offset, order).getData();
  }

  /**
   * Search mosaic restrictions
   * Returns an array of mosaic restrictions.
   * @param mosaicId Filter by mosaic identifier. (optional)
   * @param entryType Filter by entry type. (optional)
   * @param targetAddress Filter by target address. (optional)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ApiResponse&lt;MosaicRestrictionsPage&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MosaicRestrictionsPage> searchMosaicRestrictionsWithHttpInfo(String mosaicId, MosaicRestrictionEntryTypeEnum entryType, String targetAddress, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/restrictions/mosaic";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "mosaicId", mosaicId));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "entryType", entryType));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "targetAddress", targetAddress));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MosaicRestrictionsPage> localVarReturnType = new GenericType<MosaicRestrictionsPage>() {};
    return apiClient.invokeAPI("RestrictionMosaicRoutesApi.searchMosaicRestrictions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
