package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.AccountsNamesDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.Addresses;
import io.nem.symbol.sdk.openapi.jersey2.model.AliasTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicIds;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicsNamesDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceIds;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceNameDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespacePage;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceRegistrationTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-10T22:06:29.886Z[UTC]")
public class NamespaceRoutesApi {
  private ApiClient apiClient;

  public NamespaceRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public NamespaceRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Get readable names for a set of accountIds
   * Returns friendly names for accounts.
   * @param addresses  (required)
   * @return AccountsNamesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public AccountsNamesDTO getAccountsNames(Addresses addresses) throws ApiException {
    return getAccountsNamesWithHttpInfo(addresses).getData();
  }

  /**
   * Get readable names for a set of accountIds
   * Returns friendly names for accounts.
   * @param addresses  (required)
   * @return ApiResponse&lt;AccountsNamesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<AccountsNamesDTO> getAccountsNamesWithHttpInfo(Addresses addresses) throws ApiException {
    Object localVarPostBody = addresses;
    
    // verify the required parameter 'addresses' is set
    if (addresses == null) {
      throw new ApiException(400, "Missing the required parameter 'addresses' when calling getAccountsNames");
    }
    
    // create path and map variables
    String localVarPath = "/namespaces/account/names";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<AccountsNamesDTO> localVarReturnType = new GenericType<AccountsNamesDTO>() {};
    return apiClient.invokeAPI("NamespaceRoutesApi.getAccountsNames", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get readable names for a set of mosaics
   * Returns friendly names for mosaics.
   * @param mosaicIds  (required)
   * @return MosaicsNamesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MosaicsNamesDTO getMosaicsNames(MosaicIds mosaicIds) throws ApiException {
    return getMosaicsNamesWithHttpInfo(mosaicIds).getData();
  }

  /**
   * Get readable names for a set of mosaics
   * Returns friendly names for mosaics.
   * @param mosaicIds  (required)
   * @return ApiResponse&lt;MosaicsNamesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MosaicsNamesDTO> getMosaicsNamesWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
    Object localVarPostBody = mosaicIds;
    
    // verify the required parameter 'mosaicIds' is set
    if (mosaicIds == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicIds' when calling getMosaicsNames");
    }
    
    // create path and map variables
    String localVarPath = "/namespaces/mosaic/names";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MosaicsNamesDTO> localVarReturnType = new GenericType<MosaicsNamesDTO>() {};
    return apiClient.invokeAPI("NamespaceRoutesApi.getMosaicsNames", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get namespace information
   * Gets the namespace for a given namespace identifier.
   * @param namespaceId Namespace identifier. (required)
   * @return NamespaceInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public NamespaceInfoDTO getNamespace(String namespaceId) throws ApiException {
    return getNamespaceWithHttpInfo(namespaceId).getData();
  }

  /**
   * Get namespace information
   * Gets the namespace for a given namespace identifier.
   * @param namespaceId Namespace identifier. (required)
   * @return ApiResponse&lt;NamespaceInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<NamespaceInfoDTO> getNamespaceWithHttpInfo(String namespaceId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'namespaceId' is set
    if (namespaceId == null) {
      throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespace");
    }
    
    // create path and map variables
    String localVarPath = "/namespaces/{namespaceId}"
      .replaceAll("\\{" + "namespaceId" + "\\}", apiClient.escapeString(namespaceId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<NamespaceInfoDTO> localVarReturnType = new GenericType<NamespaceInfoDTO>() {};
    return apiClient.invokeAPI("NamespaceRoutesApi.getNamespace", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get namespace merkle information
   * Gets the namespace merkle for a given namespace identifier.
   * @param namespaceId Namespace identifier. (required)
   * @return MerkleStateInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MerkleStateInfoDTO getNamespaceMerkle(String namespaceId) throws ApiException {
    return getNamespaceMerkleWithHttpInfo(namespaceId).getData();
  }

  /**
   * Get namespace merkle information
   * Gets the namespace merkle for a given namespace identifier.
   * @param namespaceId Namespace identifier. (required)
   * @return ApiResponse&lt;MerkleStateInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MerkleStateInfoDTO> getNamespaceMerkleWithHttpInfo(String namespaceId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'namespaceId' is set
    if (namespaceId == null) {
      throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMerkle");
    }
    
    // create path and map variables
    String localVarPath = "/namespaces/{namespaceId}/merkle"
      .replaceAll("\\{" + "namespaceId" + "\\}", apiClient.escapeString(namespaceId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MerkleStateInfoDTO> localVarReturnType = new GenericType<MerkleStateInfoDTO>() {};
    return apiClient.invokeAPI("NamespaceRoutesApi.getNamespaceMerkle", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get readable names for a set of namespaces
   * Returns friendly names for namespaces.
   * @param namespaceIds  (required)
   * @return List&lt;NamespaceNameDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<NamespaceNameDTO> getNamespacesNames(NamespaceIds namespaceIds) throws ApiException {
    return getNamespacesNamesWithHttpInfo(namespaceIds).getData();
  }

  /**
   * Get readable names for a set of namespaces
   * Returns friendly names for namespaces.
   * @param namespaceIds  (required)
   * @return ApiResponse&lt;List&lt;NamespaceNameDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<NamespaceNameDTO>> getNamespacesNamesWithHttpInfo(NamespaceIds namespaceIds) throws ApiException {
    Object localVarPostBody = namespaceIds;
    
    // verify the required parameter 'namespaceIds' is set
    if (namespaceIds == null) {
      throw new ApiException(400, "Missing the required parameter 'namespaceIds' when calling getNamespacesNames");
    }
    
    // create path and map variables
    String localVarPath = "/namespaces/names";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<NamespaceNameDTO>> localVarReturnType = new GenericType<List<NamespaceNameDTO>>() {};
    return apiClient.invokeAPI("NamespaceRoutesApi.getNamespacesNames", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Search namespaces
   * Gets an array of namespaces.
   * @param ownerAddress Filter by owner address. (optional)
   * @param registrationType Filter by registration type. (optional)
   * @param level0 Filter by root namespace. (optional)
   * @param aliasType Filter by alias type. (optional)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return NamespacePage
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public NamespacePage searchNamespaces(String ownerAddress, NamespaceRegistrationTypeEnum registrationType, String level0, AliasTypeEnum aliasType, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    return searchNamespacesWithHttpInfo(ownerAddress, registrationType, level0, aliasType, pageSize, pageNumber, offset, order).getData();
  }

  /**
   * Search namespaces
   * Gets an array of namespaces.
   * @param ownerAddress Filter by owner address. (optional)
   * @param registrationType Filter by registration type. (optional)
   * @param level0 Filter by root namespace. (optional)
   * @param aliasType Filter by alias type. (optional)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ApiResponse&lt;NamespacePage&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<NamespacePage> searchNamespacesWithHttpInfo(String ownerAddress, NamespaceRegistrationTypeEnum registrationType, String level0, AliasTypeEnum aliasType, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/namespaces";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "ownerAddress", ownerAddress));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "registrationType", registrationType));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "level0", level0));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "aliasType", aliasType));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<NamespacePage> localVarReturnType = new GenericType<NamespacePage>() {};
    return apiClient.invokeAPI("NamespaceRoutesApi.searchNamespaces", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
