package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.BlockInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.BlockOrderByEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.BlockPage;
import io.nem.symbol.sdk.openapi.jersey2.model.MerkleProofInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-10T22:06:29.886Z[UTC]")
public class BlockRoutesApi {
  private ApiClient apiClient;

  public BlockRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public BlockRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Get block information
   * Gets a block from the chain that has the given height.
   * @param height Block height. (required)
   * @return BlockInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public BlockInfoDTO getBlockByHeight(java.math.BigInteger height) throws ApiException {
    return getBlockByHeightWithHttpInfo(height).getData();
  }

  /**
   * Get block information
   * Gets a block from the chain that has the given height.
   * @param height Block height. (required)
   * @return ApiResponse&lt;BlockInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<BlockInfoDTO> getBlockByHeightWithHttpInfo(java.math.BigInteger height) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'height' is set
    if (height == null) {
      throw new ApiException(400, "Missing the required parameter 'height' when calling getBlockByHeight");
    }
    
    // create path and map variables
    String localVarPath = "/blocks/{height}"
      .replaceAll("\\{" + "height" + "\\}", apiClient.escapeString(height.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<BlockInfoDTO> localVarReturnType = new GenericType<BlockInfoDTO>() {};
    return apiClient.invokeAPI("BlockRoutesApi.getBlockByHeight", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get the merkle path for a given a receipt statement hash and block
   * Returns the merkle path for a receipt statement or resolution linked to a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.receiptsHash) to verify if the statement was linked with the block. 
   * @param height Block height. (required)
   * @param hash Receipt hash. (required)
   * @return MerkleProofInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MerkleProofInfoDTO getMerkleReceipts(java.math.BigInteger height, String hash) throws ApiException {
    return getMerkleReceiptsWithHttpInfo(height, hash).getData();
  }

  /**
   * Get the merkle path for a given a receipt statement hash and block
   * Returns the merkle path for a receipt statement or resolution linked to a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.receiptsHash) to verify if the statement was linked with the block. 
   * @param height Block height. (required)
   * @param hash Receipt hash. (required)
   * @return ApiResponse&lt;MerkleProofInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MerkleProofInfoDTO> getMerkleReceiptsWithHttpInfo(java.math.BigInteger height, String hash) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'height' is set
    if (height == null) {
      throw new ApiException(400, "Missing the required parameter 'height' when calling getMerkleReceipts");
    }
    
    // verify the required parameter 'hash' is set
    if (hash == null) {
      throw new ApiException(400, "Missing the required parameter 'hash' when calling getMerkleReceipts");
    }
    
    // create path and map variables
    String localVarPath = "/blocks/{height}/statements/{hash}/merkle"
      .replaceAll("\\{" + "height" + "\\}", apiClient.escapeString(height.toString()))
      .replaceAll("\\{" + "hash" + "\\}", apiClient.escapeString(hash.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MerkleProofInfoDTO> localVarReturnType = new GenericType<MerkleProofInfoDTO>() {};
    return apiClient.invokeAPI("BlockRoutesApi.getMerkleReceipts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get the merkle path for a given a transaction and block
   * Returns the merkle path for a transaction included in a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.transactionsHash) to verify if the transaction was included in the block. 
   * @param height Block height. (required)
   * @param hash Transaction hash. (required)
   * @return MerkleProofInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MerkleProofInfoDTO getMerkleTransaction(java.math.BigInteger height, String hash) throws ApiException {
    return getMerkleTransactionWithHttpInfo(height, hash).getData();
  }

  /**
   * Get the merkle path for a given a transaction and block
   * Returns the merkle path for a transaction included in a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.transactionsHash) to verify if the transaction was included in the block. 
   * @param height Block height. (required)
   * @param hash Transaction hash. (required)
   * @return ApiResponse&lt;MerkleProofInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MerkleProofInfoDTO> getMerkleTransactionWithHttpInfo(java.math.BigInteger height, String hash) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'height' is set
    if (height == null) {
      throw new ApiException(400, "Missing the required parameter 'height' when calling getMerkleTransaction");
    }
    
    // verify the required parameter 'hash' is set
    if (hash == null) {
      throw new ApiException(400, "Missing the required parameter 'hash' when calling getMerkleTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/blocks/{height}/transactions/{hash}/merkle"
      .replaceAll("\\{" + "height" + "\\}", apiClient.escapeString(height.toString()))
      .replaceAll("\\{" + "hash" + "\\}", apiClient.escapeString(hash.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MerkleProofInfoDTO> localVarReturnType = new GenericType<MerkleProofInfoDTO>() {};
    return apiClient.invokeAPI("BlockRoutesApi.getMerkleTransaction", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Search blocks
   * Gets an array of bocks.
   * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
   * @param beneficiaryAddress Filter by beneficiary address. (optional)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @param orderBy Sort responses by the property set.  (optional)
   * @return BlockPage
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public BlockPage searchBlocks(String signerPublicKey, String beneficiaryAddress, Integer pageSize, Integer pageNumber, String offset, Order order, BlockOrderByEnum orderBy) throws ApiException {
    return searchBlocksWithHttpInfo(signerPublicKey, beneficiaryAddress, pageSize, pageNumber, offset, order, orderBy).getData();
  }

  /**
   * Search blocks
   * Gets an array of bocks.
   * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
   * @param beneficiaryAddress Filter by beneficiary address. (optional)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @param orderBy Sort responses by the property set.  (optional)
   * @return ApiResponse&lt;BlockPage&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<BlockPage> searchBlocksWithHttpInfo(String signerPublicKey, String beneficiaryAddress, Integer pageSize, Integer pageNumber, String offset, Order order, BlockOrderByEnum orderBy) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/blocks";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "signerPublicKey", signerPublicKey));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "beneficiaryAddress", beneficiaryAddress));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "orderBy", orderBy));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<BlockPage> localVarReturnType = new GenericType<BlockPage>() {};
    return apiClient.invokeAPI("BlockRoutesApi.searchBlocks", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
