/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.2.0
 *
 * The version of the OpenAPI document: 0.10.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.jersey2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.jersey2.model.BalanceTransferReceiptDTOAllOf;
import io.nem.symbol.sdk.openapi.jersey2.model.ReceiptDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.ReceiptTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Receipt stored when a state change that triggered a mosaic transfer.
 */
@ApiModel(description = "Receipt stored when a state change that triggered a mosaic transfer.")
@JsonPropertyOrder({
  BalanceTransferReceiptDTO.JSON_PROPERTY_VERSION,
  BalanceTransferReceiptDTO.JSON_PROPERTY_TYPE,
  BalanceTransferReceiptDTO.JSON_PROPERTY_MOSAIC_ID,
  BalanceTransferReceiptDTO.JSON_PROPERTY_AMOUNT,
  BalanceTransferReceiptDTO.JSON_PROPERTY_SENDER_ADDRESS,
  BalanceTransferReceiptDTO.JSON_PROPERTY_RECIPIENT_ADDRESS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-08T20:58:53.852Z[UTC]")
public class BalanceTransferReceiptDTO {
  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_TYPE = "type";
  private ReceiptTypeEnum type;

  public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
  private String mosaicId;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private java.math.BigInteger amount = null;

  public static final String JSON_PROPERTY_SENDER_ADDRESS = "senderAddress";
  private String senderAddress;

  public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
  private String recipientAddress;


  public BalanceTransferReceiptDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version of the receipt.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Version of the receipt.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public BalanceTransferReceiptDTO type(ReceiptTypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ReceiptTypeEnum getType() {
    return type;
  }


  public void setType(ReceiptTypeEnum type) {
    this.type = type;
  }


  public BalanceTransferReceiptDTO mosaicId(String mosaicId) {
    
    this.mosaicId = mosaicId;
    return this;
  }

   /**
   * Mosaic identifier.
   * @return mosaicId
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Mosaic identifier.")
  @JsonProperty(JSON_PROPERTY_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMosaicId() {
    return mosaicId;
  }


  public void setMosaicId(String mosaicId) {
    this.mosaicId = mosaicId;
  }


  public BalanceTransferReceiptDTO amount(java.math.BigInteger amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return amount
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getAmount() {
    return amount;
  }


  public void setAmount(java.math.BigInteger amount) {
    this.amount = amount;
  }


  public BalanceTransferReceiptDTO senderAddress(String senderAddress) {
    
    this.senderAddress = senderAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base.
   * @return senderAddress
  **/
  @ApiModelProperty(example = "9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required = true, value = "Address expressed in hexadecimal base.")
  @JsonProperty(JSON_PROPERTY_SENDER_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSenderAddress() {
    return senderAddress;
  }


  public void setSenderAddress(String senderAddress) {
    this.senderAddress = senderAddress;
  }


  public BalanceTransferReceiptDTO recipientAddress(String recipientAddress) {
    
    this.recipientAddress = recipientAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base.
   * @return recipientAddress
  **/
  @ApiModelProperty(example = "9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required = true, value = "Address expressed in hexadecimal base.")
  @JsonProperty(JSON_PROPERTY_RECIPIENT_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRecipientAddress() {
    return recipientAddress;
  }


  public void setRecipientAddress(String recipientAddress) {
    this.recipientAddress = recipientAddress;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceTransferReceiptDTO balanceTransferReceiptDTO = (BalanceTransferReceiptDTO) o;
    return Objects.equals(this.version, balanceTransferReceiptDTO.version) &&
        Objects.equals(this.type, balanceTransferReceiptDTO.type) &&
        Objects.equals(this.mosaicId, balanceTransferReceiptDTO.mosaicId) &&
        Objects.equals(this.amount, balanceTransferReceiptDTO.amount) &&
        Objects.equals(this.senderAddress, balanceTransferReceiptDTO.senderAddress) &&
        Objects.equals(this.recipientAddress, balanceTransferReceiptDTO.recipientAddress);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, type, mosaicId, amount, senderAddress, recipientAddress);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceTransferReceiptDTO {\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    mosaicId: ").append(toIndentedString(mosaicId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    senderAddress: ").append(toIndentedString(senderAddress)).append("\n");
    sb.append("    recipientAddress: ").append(toIndentedString(recipientAddress)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

