package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.FinalizationProofDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-08T20:58:53.852Z[UTC]")
public class FinalizationRoutesApi {
  private ApiClient apiClient;

  public FinalizationRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public FinalizationRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Get finalization proof
   * Gets finalization proof for the greatest height associated with the given epoch.
   * @param epoch Finalization epoch. (required)
   * @return FinalizationProofDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public FinalizationProofDTO getFinalizationProofAtEpoch(Long epoch) throws ApiException {
    return getFinalizationProofAtEpochWithHttpInfo(epoch).getData();
  }

  /**
   * Get finalization proof
   * Gets finalization proof for the greatest height associated with the given epoch.
   * @param epoch Finalization epoch. (required)
   * @return ApiResponse&lt;FinalizationProofDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<FinalizationProofDTO> getFinalizationProofAtEpochWithHttpInfo(Long epoch) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'epoch' is set
    if (epoch == null) {
      throw new ApiException(400, "Missing the required parameter 'epoch' when calling getFinalizationProofAtEpoch");
    }
    
    // create path and map variables
    String localVarPath = "/finalization/proof/epoch/{epoch}"
      .replaceAll("\\{" + "epoch" + "\\}", apiClient.escapeString(epoch.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<FinalizationProofDTO> localVarReturnType = new GenericType<FinalizationProofDTO>() {};
    return apiClient.invokeAPI("FinalizationRoutesApi.getFinalizationProofAtEpoch", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get finalization proof
   * Gets finalization proof at the given height.
   * @param height Block height. (required)
   * @return FinalizationProofDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public FinalizationProofDTO getFinalizationProofAtHeight(java.math.BigInteger height) throws ApiException {
    return getFinalizationProofAtHeightWithHttpInfo(height).getData();
  }

  /**
   * Get finalization proof
   * Gets finalization proof at the given height.
   * @param height Block height. (required)
   * @return ApiResponse&lt;FinalizationProofDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<FinalizationProofDTO> getFinalizationProofAtHeightWithHttpInfo(java.math.BigInteger height) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'height' is set
    if (height == null) {
      throw new ApiException(400, "Missing the required parameter 'height' when calling getFinalizationProofAtHeight");
    }
    
    // create path and map variables
    String localVarPath = "/finalization/proof/height/{height}"
      .replaceAll("\\{" + "height" + "\\}", apiClient.escapeString(height.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<FinalizationProofDTO> localVarReturnType = new GenericType<FinalizationProofDTO>() {};
    return apiClient.invokeAPI("FinalizationRoutesApi.getFinalizationProofAtHeight", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
