/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.Mosaic;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.Message;
import io.nem.sdk.model.transaction.MessageBuffer;
import io.nem.sdk.model.transaction.MosaicBuffer;
import io.nem.sdk.model.transaction.Schema;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.model.transaction.TransferTransactionBuffer;
import io.nem.sdk.model.transaction.TransferTransactionSchema;
import io.nem.sdk.model.transaction.UInt64;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang3.Validate;

public class TransferTransaction
extends Transaction {
    private final Address recipient;
    private final List<Mosaic> mosaics;
    private final Message message;
    private final Schema schema = new TransferTransactionSchema();

    public TransferTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, Address recipient, List<Mosaic> mosaics, Message message, String signature, PublicAccount signer, TransactionInfo transactionInfo) {
        this(networkType, version, deadline, fee, recipient, mosaics, message, Optional.of(signature), Optional.of(signer), Optional.of(transactionInfo));
    }

    public TransferTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, Address recipient, List<Mosaic> mosaics, Message message) {
        this(networkType, version, deadline, fee, recipient, mosaics, message, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private TransferTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, Address recipient, List<Mosaic> mosaics, Message message, Optional<String> signature, Optional<PublicAccount> signer, Optional<TransactionInfo> transactionInfo) {
        super(TransactionType.TRANSFER, networkType, version, deadline, fee, signature, signer, transactionInfo);
        Validate.notNull((Object)recipient, (String)"Recipient must not be null", (Object[])new Object[0]);
        Validate.notNull(mosaics, (String)"Mosaics must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)message, (String)"Message must not be null", (Object[])new Object[0]);
        this.recipient = recipient;
        this.mosaics = mosaics;
        this.message = message;
    }

    public static TransferTransaction create(Deadline deadline, Address recipient, List<Mosaic> mosaics, Message message, NetworkType networkType) {
        return new TransferTransaction(networkType, 3, deadline, BigInteger.valueOf(0L), recipient, mosaics, message);
    }

    public Address getRecipient() {
        return this.recipient;
    }

    public List<Mosaic> getMosaics() {
        return this.mosaics;
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    byte[] generateBytes() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        BigInteger deadlineBigInt = BigInteger.valueOf(this.getDeadline().getInstant());
        int[] fee = new int[]{0, 0};
        int version = (int)Long.parseLong(Integer.toHexString(this.getNetworkType().getValue()) + "0" + Integer.toHexString(this.getVersion()), 16);
        byte[] bytePayload = this.message.getPayload().getBytes(StandardCharsets.UTF_8);
        int payload = MessageBuffer.createPayloadVector(builder, bytePayload);
        MessageBuffer.startMessageBuffer(builder);
        MessageBuffer.addType(builder, this.message.getType());
        MessageBuffer.addPayload(builder, payload);
        int message = MessageBuffer.endMessageBuffer(builder);
        int[] mosaicBuffers = new int[this.mosaics.size()];
        for (int i = 0; i < this.mosaics.size(); ++i) {
            Mosaic mosaic = this.mosaics.get(i);
            int id = MosaicBuffer.createIdVector(builder, UInt64.fromBigInteger(mosaic.getId().getId()));
            int amount = MosaicBuffer.createAmountVector(builder, UInt64.fromBigInteger(mosaic.getAmount()));
            MosaicBuffer.startMosaicBuffer(builder);
            MosaicBuffer.addId(builder, id);
            MosaicBuffer.addAmount(builder, amount);
            mosaicBuffers[i] = MosaicBuffer.endMosaicBuffer(builder);
        }
        byte[] address = new Base32().decode(this.getRecipient().plain().getBytes(StandardCharsets.UTF_8));
        int signatureVector = TransferTransactionBuffer.createSignatureVector(builder, new byte[64]);
        int signerVector = TransferTransactionBuffer.createSignerVector(builder, new byte[32]);
        int deadlineVector = TransferTransactionBuffer.createDeadlineVector(builder, UInt64.fromBigInteger(deadlineBigInt));
        int feeVector = TransferTransactionBuffer.createFeeVector(builder, fee);
        int recipientVector = TransferTransactionBuffer.createRecipientVector(builder, address);
        int mosaicsVector = TransferTransactionBuffer.createMosaicsVector(builder, mosaicBuffers);
        int fixSize = 149;
        TransferTransactionBuffer.startTransferTransactionBuffer(builder);
        TransferTransactionBuffer.addSize(builder, fixSize + 16 * this.mosaics.size() + bytePayload.length);
        TransferTransactionBuffer.addSignature(builder, signatureVector);
        TransferTransactionBuffer.addSigner(builder, signerVector);
        TransferTransactionBuffer.addVersion(builder, version);
        TransferTransactionBuffer.addType(builder, this.getType().getValue());
        TransferTransactionBuffer.addFee(builder, feeVector);
        TransferTransactionBuffer.addDeadline(builder, deadlineVector);
        TransferTransactionBuffer.addRecipient(builder, recipientVector);
        TransferTransactionBuffer.addNumMosaics(builder, this.mosaics.size());
        TransferTransactionBuffer.addMessageSize(builder, bytePayload.length + 1);
        TransferTransactionBuffer.addMessage(builder, message);
        TransferTransactionBuffer.addMosaics(builder, mosaicsVector);
        int codedTransfer = TransferTransactionBuffer.endTransferTransactionBuffer(builder);
        builder.finish(codedTransfer);
        return this.schema.serialize(builder.sizedByteArray());
    }
}

