/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

public enum TransactionType {
    AGGREGATE_COMPLETE(16705),
    AGGREGATE_BONDED(16961),
    MOSAIC_DEFINITION(16717),
    MOSAIC_SUPPLY_CHANGE(16973),
    MODIFY_MULTISIG_ACCOUNT(16725),
    REGISTER_NAMESPACE(16718),
    TRANSFER(16724),
    LOCK(16716),
    SECRET_LOCK(16972),
    SECRET_PROOF(17228);

    private int value;

    private TransactionType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static TransactionType rawValueOf(int value) {
        switch (value) {
            case 16724: {
                return TRANSFER;
            }
            case 16718: {
                return REGISTER_NAMESPACE;
            }
            case 16717: {
                return MOSAIC_DEFINITION;
            }
            case 16973: {
                return MOSAIC_SUPPLY_CHANGE;
            }
            case 16725: {
                return MODIFY_MULTISIG_ACCOUNT;
            }
            case 16716: {
                return LOCK;
            }
            case 16972: {
                return SECRET_LOCK;
            }
            case 17228: {
                return SECRET_PROOF;
            }
            case 16705: {
                return AGGREGATE_COMPLETE;
            }
            case 16961: {
                return AGGREGATE_BONDED;
            }
        }
        throw new IllegalArgumentException(value + " is not a valid value");
    }
}

