/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class TransactionInfo {
    private final BigInteger height;
    private final Optional<Integer> index;
    private final Optional<String> id;
    private final Optional<String> hash;
    private final Optional<String> merkleComponentHash;
    private final Optional<String> aggregateHash;
    private final Optional<String> aggregateId;

    private TransactionInfo(BigInteger height, Optional<Integer> index, Optional<String> id, Optional<String> hash, Optional<String> merkleComponentHash, Optional<String> aggregateHash, Optional<String> aggregateId) {
        Validate.notNull((Object)height, (String)"Height must not be null", (Object[])new Object[0]);
        this.height = height;
        this.index = index;
        this.id = id;
        this.hash = hash;
        this.merkleComponentHash = merkleComponentHash;
        this.aggregateHash = aggregateHash;
        this.aggregateId = aggregateId;
    }

    public static TransactionInfo createAggregate(BigInteger height, Integer index, String id, String aggregateHash, String aggregateId) {
        return new TransactionInfo(height, Optional.of(index), Optional.of(id), Optional.empty(), Optional.empty(), Optional.of(aggregateHash), Optional.of(aggregateId));
    }

    public static TransactionInfo create(BigInteger height, Integer index, String id, String hash, String merkleComponentHash) {
        return new TransactionInfo(height, Optional.of(index), Optional.of(id), Optional.of(hash), Optional.of(merkleComponentHash), Optional.empty(), Optional.empty());
    }

    public static TransactionInfo create(BigInteger height, String hash, String merkleComponentHash) {
        return new TransactionInfo(height, Optional.empty(), Optional.empty(), Optional.of(hash), Optional.of(merkleComponentHash), Optional.empty(), Optional.empty());
    }

    public BigInteger getHeight() {
        return this.height;
    }

    public Optional<Integer> getIndex() {
        return this.index;
    }

    public Optional<String> getId() {
        return this.id;
    }

    public Optional<String> getHash() {
        return this.hash;
    }

    public Optional<String> getMerkleComponentHash() {
        return this.merkleComponentHash;
    }

    public Optional<String> getAggregateHash() {
        return this.aggregateHash;
    }

    public Optional<String> getAggregateId() {
        return this.aggregateId;
    }
}

