/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import io.nem.core.crypto.Hashes;
import io.nem.core.crypto.Signature;
import io.nem.core.crypto.Signer;
import io.nem.sdk.model.account.Account;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.SignedTransaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.util.encoders.Hex;

public abstract class Transaction {
    private final TransactionType type;
    private final NetworkType networkType;
    private final Integer version;
    private final Deadline deadline;
    private final BigInteger fee;
    private final Optional<String> signature;
    private Optional<PublicAccount> signer;
    private final Optional<TransactionInfo> transactionInfo;

    public Transaction(TransactionType type, NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, Optional<String> signature, Optional<PublicAccount> signer, Optional<TransactionInfo> transactionInfo) {
        Validate.notNull((Object)((Object)type), (String)"Type must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)networkType), (String)"NetworkType must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)version, (String)"Version must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)deadline, (String)"Deadline must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)fee, (String)"Fee must not be null", (Object[])new Object[0]);
        this.type = type;
        this.networkType = networkType;
        this.version = version;
        this.deadline = deadline;
        this.fee = fee;
        this.signature = signature;
        this.signer = signer;
        this.transactionInfo = transactionInfo;
    }

    public static String createTransactionHash(String transactionPayload) {
        byte[] bytes = Hex.decode((String)transactionPayload);
        byte[] signingBytes = new byte[bytes.length - 36];
        System.arraycopy(bytes, 4, signingBytes, 0, 32);
        System.arraycopy(bytes, 68, signingBytes, 32, bytes.length - 68);
        byte[] result = Hashes.sha3_256(new byte[][]{signingBytes});
        return Hex.toHexString((byte[])result).toUpperCase();
    }

    public TransactionType getType() {
        return this.type;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Deadline getDeadline() {
        return this.deadline;
    }

    public BigInteger getFee() {
        return this.fee;
    }

    public Optional<String> getSignature() {
        return this.signature;
    }

    public Optional<PublicAccount> getSigner() {
        return this.signer;
    }

    public Optional<TransactionInfo> getTransactionInfo() {
        return this.transactionInfo;
    }

    abstract byte[] generateBytes();

    public SignedTransaction signWith(Account account) {
        Signer signer = new Signer(account.getKeyPair());
        byte[] bytes = this.generateBytes();
        byte[] signingBytes = new byte[bytes.length - 100];
        System.arraycopy(bytes, 100, signingBytes, 0, bytes.length - 100);
        Signature signature = signer.sign(signingBytes);
        byte[] payload = new byte[bytes.length];
        System.arraycopy(bytes, 0, payload, 0, 4);
        System.arraycopy(signature.getBytes(), 0, payload, 4, signature.getBytes().length);
        System.arraycopy(account.getKeyPair().getPublicKey().getRaw(), 0, payload, 68, account.getKeyPair().getPublicKey().getRaw().length);
        System.arraycopy(bytes, 100, payload, 100, bytes.length - 100);
        String hash = Transaction.createTransactionHash(Hex.toHexString((byte[])payload));
        return new SignedTransaction(Hex.toHexString((byte[])payload).toUpperCase(), hash, this.type);
    }

    byte[] toAggregateTransactionBytes() {
        byte[] signerBytes = Hex.decode((String)this.signer.get().getPublicKey());
        byte[] bytes = this.generateBytes();
        byte[] resultBytes = new byte[bytes.length - 64 - 16];
        System.arraycopy(signerBytes, 0, resultBytes, 4, 32);
        System.arraycopy(bytes, 100, resultBytes, 36, 4);
        System.arraycopy(bytes, 120, resultBytes, 40, bytes.length - 120);
        byte[] size = BigInteger.valueOf(bytes.length - 64 - 16).toByteArray();
        ArrayUtils.reverse((byte[])size);
        System.arraycopy(size, 0, resultBytes, 0, size.length);
        return resultBytes;
    }

    public Transaction toAggregate(PublicAccount signer) {
        this.signer = Optional.of(signer);
        return this;
    }

    public boolean isUnconfirmed() {
        return this.transactionInfo.isPresent() && this.transactionInfo.get().getHeight().equals(BigInteger.valueOf(0L)) && this.transactionInfo.get().getHash().equals(this.transactionInfo.get().getMerkleComponentHash());
    }

    public boolean isConfirmed() {
        return this.transactionInfo.isPresent() && this.transactionInfo.get().getHeight().intValue() > 0;
    }

    public boolean hasMissingSignatures() {
        return this.transactionInfo.isPresent() && this.transactionInfo.get().getHeight().equals(BigInteger.valueOf(0L)) && !this.transactionInfo.get().getHash().equals(this.transactionInfo.get().getMerkleComponentHash());
    }

    public boolean isUnannounced() {
        return !this.transactionInfo.isPresent();
    }
}

