/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import io.nem.sdk.model.transaction.Schema;
import io.nem.sdk.model.transaction.SchemaAttribute;
import java.util.List;

class TableArrayAttribute
extends SchemaAttribute {
    private final List<SchemaAttribute> schema;

    TableArrayAttribute(String name, List<SchemaAttribute> schema) {
        super(name);
        this.schema = schema;
    }

    @Override
    byte[] serialize(byte[] buffer, int position, int innerObjectPosition) {
        byte[] resultBytes = new byte[]{};
        int arrayLength = this.findArrayLength(innerObjectPosition, position, buffer);
        for (int i = 0; i < arrayLength; ++i) {
            int startArrayPosition = this.findObjectArrayElementStartPosition(innerObjectPosition, position, buffer, i);
            for (int j = 0; j < this.schema.size(); ++j) {
                byte[] tmp = this.schema.get(j).serialize(buffer, 4 + j * 2, startArrayPosition);
                resultBytes = Schema.concat(resultBytes, tmp);
            }
        }
        return resultBytes;
    }
}

