/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.HashType;
import io.nem.sdk.model.transaction.Schema;
import io.nem.sdk.model.transaction.SecretProofTransactionBuffer;
import io.nem.sdk.model.transaction.SecretProofTransactionSchema;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.model.transaction.UInt64;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.util.encoders.Hex;

public class SecretProofTransaction
extends Transaction {
    private final HashType hashType;
    private final String secret;
    private final String proof;
    private final Schema schema = new SecretProofTransactionSchema();

    public SecretProofTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, HashType hashType, String secret, String proof, String signature, PublicAccount signer, TransactionInfo transactionInfo) {
        this(networkType, version, deadline, fee, hashType, secret, proof, Optional.of(signature), Optional.of(signer), Optional.of(transactionInfo));
    }

    public SecretProofTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, HashType hashType, String secret, String proof) {
        this(networkType, version, deadline, fee, hashType, secret, proof, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public SecretProofTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, HashType hashType, String secret, String proof, Optional<String> signature, Optional<PublicAccount> signer, Optional<TransactionInfo> transactionInfo) {
        super(TransactionType.SECRET_PROOF, networkType, version, deadline, fee, signature, signer, transactionInfo);
        Validate.notNull((Object)secret, (String)"Secret must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)proof, (String)"Proof must not be null", (Object[])new Object[0]);
        if (!HashType.Validator(hashType, secret)) {
            throw new IllegalArgumentException("HashType and Secret have incompatible length or not hexadecimal string");
        }
        this.hashType = hashType;
        this.secret = secret;
        this.proof = proof;
    }

    public static SecretProofTransaction create(Deadline deadline, HashType hashType, String secret, String proof, NetworkType networkType) {
        return new SecretProofTransaction(networkType, 3, deadline, BigInteger.valueOf(0L), hashType, secret, proof);
    }

    public HashType getHashType() {
        return this.hashType;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getProof() {
        return this.proof;
    }

    @Override
    byte[] generateBytes() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        BigInteger deadlineBigInt = BigInteger.valueOf(this.getDeadline().getInstant());
        int[] fee = new int[]{0, 0};
        int version = (int)Long.parseLong(Integer.toHexString(this.getNetworkType().getValue()) + "0" + Integer.toHexString(this.getVersion()), 16);
        int signatureVector = SecretProofTransactionBuffer.createSignatureVector(builder, new byte[64]);
        int signerVector = SecretProofTransactionBuffer.createSignerVector(builder, new byte[32]);
        int deadlineVector = SecretProofTransactionBuffer.createDeadlineVector(builder, UInt64.fromBigInteger(deadlineBigInt));
        int feeVector = SecretProofTransactionBuffer.createFeeVector(builder, fee);
        int secretVector = SecretProofTransactionBuffer.createSecretVector(builder, Hex.decode((String)this.secret));
        int proofVector = SecretProofTransactionBuffer.createProofVector(builder, Hex.decode((String)this.proof));
        SecretProofTransactionBuffer.startSecretProofTransactionBuffer(builder);
        SecretProofTransactionBuffer.addSize(builder, 187 + Hex.decode((String)this.proof).length);
        SecretProofTransactionBuffer.addSignature(builder, signatureVector);
        SecretProofTransactionBuffer.addSigner(builder, signerVector);
        SecretProofTransactionBuffer.addVersion(builder, version);
        SecretProofTransactionBuffer.addType(builder, this.getType().getValue());
        SecretProofTransactionBuffer.addFee(builder, feeVector);
        SecretProofTransactionBuffer.addDeadline(builder, deadlineVector);
        SecretProofTransactionBuffer.addHashAlgorithm(builder, this.hashType.getValue());
        SecretProofTransactionBuffer.addSecret(builder, secretVector);
        SecretProofTransactionBuffer.addProofSize(builder, Hex.decode((String)this.proof).length);
        SecretProofTransactionBuffer.addProof(builder, proofVector);
        int codedSecretProof = SecretProofTransactionBuffer.endSecretProofTransactionBuffer(builder);
        builder.finish(codedSecretProof);
        return this.schema.serialize(builder.sizedByteArray());
    }
}

