/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import io.nem.sdk.model.transaction.Constants;
import java.util.Arrays;

abstract class SchemaAttribute {
    private final String name;

    SchemaAttribute(String name) {
        this.name = name;
    }

    abstract byte[] serialize(byte[] var1, int var2, int var3);

    byte[] serialize(byte[] buffer, int position) {
        return this.serialize(buffer, position, buffer[0]);
    }

    public String getName() {
        return this.name;
    }

    protected byte[] findParam(int innerObjectPosition, int position, byte[] buffer, Constants typeSize) {
        byte[] byArray;
        int offset = this.__offset(innerObjectPosition, position, buffer);
        if (offset == 0) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 0;
        } else {
            byArray = Arrays.copyOfRange(buffer, offset + innerObjectPosition, offset + innerObjectPosition + typeSize.getValue());
        }
        return byArray;
    }

    protected byte[] findVector(int innerObjectPosition, int position, byte[] buffer, Constants typeSize) {
        byte[] byArray;
        int offset = this.__offset(innerObjectPosition, position, buffer);
        int offsetLong = offset + innerObjectPosition;
        int vecStart = this.__vector(offsetLong, buffer);
        int vecLength = this.__vector_length(offsetLong, buffer) * typeSize.getValue();
        if (offset == 0) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 0;
        } else {
            byArray = Arrays.copyOfRange(buffer, vecStart, vecStart + vecLength);
        }
        return byArray;
    }

    protected int findObjectStartPosition(int innerObjectPosition, int position, byte[] buffer) {
        int offset = this.__offset(innerObjectPosition, position, buffer);
        return this.__indirect(offset + innerObjectPosition, buffer);
    }

    protected int findArrayLength(int innerObjectPosition, int position, byte[] buffer) {
        int offset = this.__offset(innerObjectPosition, position, buffer);
        return offset == 0 ? 0 : this.__vector_length(innerObjectPosition + offset, buffer);
    }

    protected int findObjectArrayElementStartPosition(int innerObjectPosition, int position, byte[] buffer, int startPosition) {
        int offset = this.__offset(innerObjectPosition, position, buffer);
        int vector = this.__vector(innerObjectPosition + offset, buffer);
        return this.__indirect(vector + startPosition * 4, buffer);
    }

    protected int readInt32(int offset, byte[] buffer) {
        int value = buffer[offset + 3] << 24;
        value |= (buffer[offset + 2] & 0xFF) << 16;
        value |= (buffer[offset + 1] & 0xFF) << 8;
        return value |= buffer[offset] & 0xFF;
    }

    protected int readInt16(int offset, byte[] buffer) {
        int value = (buffer[offset + 1] & 0xFF) << 8;
        return value |= buffer[offset] & 0xFF;
    }

    protected int __offset(int innerObjectPosition, int position, byte[] buffer) {
        int vtable = innerObjectPosition - this.readInt32(innerObjectPosition, buffer);
        return position < this.readInt16(vtable, buffer) ? this.readInt16(vtable + position, buffer) : 0;
    }

    protected int __vector_length(int offset, byte[] buffer) {
        return this.readInt32(offset + this.readInt32(offset, buffer), buffer);
    }

    protected int __indirect(int offset, byte[] buffer) {
        return offset + this.readInt32(offset, buffer);
    }

    protected int __vector(int offset, byte[] buffer) {
        return offset + this.readInt32(offset, buffer) + 4;
    }
}

