/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.model.namespace.NamespaceType;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.IdGenerator;
import io.nem.sdk.model.transaction.ProvisionNamespaceTransactionBuffer;
import io.nem.sdk.model.transaction.RegisterNamespaceTransactionSchema;
import io.nem.sdk.model.transaction.Schema;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.model.transaction.UInt64;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class RegisterNamespaceTransaction
extends Transaction {
    private final String namespaceName;
    private final NamespaceId namespaceId;
    private final Optional<BigInteger> duration;
    private final Optional<NamespaceId> parentId;
    private final NamespaceType namespaceType;
    private final Schema schema = new RegisterNamespaceTransactionSchema();

    public RegisterNamespaceTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, String namespaceName, NamespaceId namespaceId, NamespaceType namespaceType, Optional<BigInteger> duration, Optional<NamespaceId> parentId, String signature, PublicAccount signer, TransactionInfo transactionInfo) {
        this(networkType, version, deadline, fee, namespaceName, namespaceId, namespaceType, duration, parentId, Optional.of(signature), Optional.of(signer), Optional.of(transactionInfo));
    }

    public RegisterNamespaceTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, String namespaceName, NamespaceId namespaceId, NamespaceType namespaceType, Optional<BigInteger> duration, Optional<NamespaceId> parentId) {
        this(networkType, version, deadline, fee, namespaceName, namespaceId, namespaceType, duration, parentId, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private RegisterNamespaceTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, String namespaceName, NamespaceId namespaceId, NamespaceType namespaceType, Optional<BigInteger> duration, Optional<NamespaceId> parentId, Optional<String> signature, Optional<PublicAccount> signer, Optional<TransactionInfo> transactionInfo) {
        super(TransactionType.REGISTER_NAMESPACE, networkType, version, deadline, fee, signature, signer, transactionInfo);
        Validate.notNull((Object)namespaceName, (String)"NamespaceName must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)namespaceType), (String)"NamespaceType must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)namespaceId, (String)"NamespaceId must not be null", (Object[])new Object[0]);
        if (namespaceType == NamespaceType.RootNamespace) {
            Validate.notNull(duration, (String)"Duration must not be null", (Object[])new Object[0]);
        } else {
            Validate.notNull(parentId, (String)"ParentId must not be null", (Object[])new Object[0]);
        }
        this.namespaceName = namespaceName;
        this.namespaceType = namespaceType;
        this.namespaceId = namespaceId;
        this.duration = duration;
        this.parentId = parentId;
    }

    public static RegisterNamespaceTransaction createRootNamespace(Deadline deadline, String namespaceName, BigInteger duration, NetworkType networkType) {
        Validate.notNull((Object)namespaceName, (String)"NamespaceName must not be null", (Object[])new Object[0]);
        return new RegisterNamespaceTransaction(networkType, 2, deadline, BigInteger.valueOf(0L), namespaceName, new NamespaceId(IdGenerator.generateNamespaceId(namespaceName)), NamespaceType.RootNamespace, Optional.of(duration), Optional.empty());
    }

    public static RegisterNamespaceTransaction createSubNamespace(Deadline deadline, String namespaceName, NamespaceId parentId, NetworkType networkType) {
        Validate.notNull((Object)namespaceName, (String)"NamespaceName must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)parentId, (String)"ParentId must not be null", (Object[])new Object[0]);
        return new RegisterNamespaceTransaction(networkType, 2, deadline, BigInteger.valueOf(0L), namespaceName, new NamespaceId(IdGenerator.generateSubNamespaceIdFromParentId(parentId.getId(), namespaceName)), NamespaceType.SubNamespace, Optional.empty(), Optional.of(parentId));
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public NamespaceId getNamespaceId() {
        return this.namespaceId;
    }

    public Optional<BigInteger> getDuration() {
        return this.duration;
    }

    public Optional<NamespaceId> getParentId() {
        return this.parentId;
    }

    public NamespaceType getNamespaceType() {
        return this.namespaceType;
    }

    @Override
    byte[] generateBytes() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        BigInteger deadlineBigInt = BigInteger.valueOf(this.getDeadline().getInstant());
        int[] fee = new int[]{0, 0};
        int version = (int)Long.parseLong(Integer.toHexString(this.getNetworkType().getValue()) + "0" + Integer.toHexString(this.getVersion()), 16);
        int signatureVector = ProvisionNamespaceTransactionBuffer.createSignatureVector(builder, new byte[64]);
        int signerVector = ProvisionNamespaceTransactionBuffer.createSignerVector(builder, new byte[32]);
        int deadlineVector = ProvisionNamespaceTransactionBuffer.createDeadlineVector(builder, UInt64.fromBigInteger(deadlineBigInt));
        int feeVector = ProvisionNamespaceTransactionBuffer.createFeeVector(builder, fee);
        int namespaceIdVector = ProvisionNamespaceTransactionBuffer.createNamespaceIdVector(builder, UInt64.fromBigInteger(this.namespaceId.getId()));
        int durationParentIdVector = ProvisionNamespaceTransactionBuffer.createDurationParentIdVector(builder, this.getNamespaceType() == NamespaceType.RootNamespace ? UInt64.fromBigInteger(this.duration.get()) : UInt64.fromBigInteger(this.parentId.get().getId()));
        int fixSize = 138;
        int name = builder.createString((CharSequence)this.namespaceName);
        ProvisionNamespaceTransactionBuffer.startProvisionNamespaceTransactionBuffer(builder);
        ProvisionNamespaceTransactionBuffer.addSize(builder, fixSize + this.namespaceName.length());
        ProvisionNamespaceTransactionBuffer.addSignature(builder, signatureVector);
        ProvisionNamespaceTransactionBuffer.addSigner(builder, signerVector);
        ProvisionNamespaceTransactionBuffer.addVersion(builder, version);
        ProvisionNamespaceTransactionBuffer.addType(builder, this.getType().getValue());
        ProvisionNamespaceTransactionBuffer.addFee(builder, feeVector);
        ProvisionNamespaceTransactionBuffer.addDeadline(builder, deadlineVector);
        ProvisionNamespaceTransactionBuffer.addNamespaceType(builder, this.getNamespaceType().getValue());
        ProvisionNamespaceTransactionBuffer.addDurationParentId(builder, durationParentIdVector);
        ProvisionNamespaceTransactionBuffer.addNamespaceId(builder, namespaceIdVector);
        ProvisionNamespaceTransactionBuffer.addNamespaceNameSize(builder, this.namespaceName.length());
        ProvisionNamespaceTransactionBuffer.addNamespaceName(builder, name);
        int codedTransaction = ProvisionNamespaceTransactionBuffer.endProvisionNamespaceTransactionBuffer(builder);
        builder.finish(codedTransaction);
        return this.schema.serialize(builder.sizedByteArray());
    }
}

