/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.mosaic.MosaicProperties;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.IdGenerator;
import io.nem.sdk.model.transaction.MosaicDefinitionCreationTransactionBuffer;
import io.nem.sdk.model.transaction.MosaicDefinitionTransactionSchema;
import io.nem.sdk.model.transaction.Schema;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.model.transaction.UInt64;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang.Validate;

public class MosaicDefinitionTransaction
extends Transaction {
    private final String mosaicName;
    private final MosaicId mosaicId;
    private final NamespaceId namespaceId;
    private final MosaicProperties mosaicProperties;
    private final Schema schema = new MosaicDefinitionTransactionSchema();

    public MosaicDefinitionTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, String mosaicName, NamespaceId namespaceId, MosaicId mosaicId, MosaicProperties mosaicProperties, String signature, PublicAccount signer, TransactionInfo transactionInfo) {
        this(networkType, version, deadline, fee, mosaicName, namespaceId, mosaicId, mosaicProperties, Optional.of(signature), Optional.of(signer), Optional.of(transactionInfo));
    }

    public MosaicDefinitionTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, String mosaicName, NamespaceId namespaceId, MosaicId mosaicId, MosaicProperties mosaicProperties) {
        this(networkType, version, deadline, fee, mosaicName, namespaceId, mosaicId, mosaicProperties, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private MosaicDefinitionTransaction(NetworkType networkType, Integer version, Deadline deadline, BigInteger fee, String mosaicName, NamespaceId namespaceId, MosaicId mosaicId, MosaicProperties mosaicProperties, Optional<String> signature, Optional<PublicAccount> signer, Optional<TransactionInfo> transactionInfo) {
        super(TransactionType.MOSAIC_DEFINITION, networkType, version, deadline, fee, signature, signer, transactionInfo);
        Validate.notNull((Object)mosaicName, (String)"MosaicName must not be null");
        Validate.notNull((Object)namespaceId, (String)"NamespaceId must not be null");
        Validate.notNull((Object)mosaicId, (String)"MosaicId must not be null");
        Validate.notNull((Object)mosaicProperties, (String)"MosaicProperties must not be null");
        this.mosaicName = mosaicName;
        this.namespaceId = namespaceId;
        this.mosaicId = mosaicId;
        this.mosaicProperties = mosaicProperties;
    }

    public static MosaicDefinitionTransaction create(Deadline deadline, String mosaicName, String namespaceName, MosaicProperties mosaicProperties, NetworkType networkType) {
        Validate.notNull((Object)mosaicName, (String)"MosaicName must not be null");
        Validate.notNull((Object)namespaceName, (String)"NamespaceName must not be null");
        return new MosaicDefinitionTransaction(networkType, 2, deadline, BigInteger.valueOf(0L), mosaicName, new NamespaceId(namespaceName), new MosaicId(IdGenerator.generateMosaicId(namespaceName, mosaicName)), mosaicProperties);
    }

    public NamespaceId getNamespaceId() {
        return this.namespaceId;
    }

    public MosaicId getMosaicId() {
        return this.mosaicId;
    }

    public String getMosaicName() {
        return this.mosaicName;
    }

    public MosaicProperties getMosaicProperties() {
        return this.mosaicProperties;
    }

    @Override
    byte[] generateBytes() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        BigInteger deadlineBigInt = BigInteger.valueOf(this.getDeadline().getInstant());
        int[] fee = new int[]{0, 0};
        int version = (int)Long.parseLong(Integer.toHexString(this.getNetworkType().getValue()) + "0" + Integer.toHexString(this.getVersion()), 16);
        int flags = 0;
        if (this.mosaicProperties.isSupplyMutable()) {
            ++flags;
        }
        if (this.mosaicProperties.isTransferable()) {
            flags += 2;
        }
        if (this.mosaicProperties.isLevyMutable()) {
            flags += 4;
        }
        int signatureVector = MosaicDefinitionCreationTransactionBuffer.createSignatureVector(builder, new byte[64]);
        int signerVector = MosaicDefinitionCreationTransactionBuffer.createSignerVector(builder, new byte[32]);
        int deadlineVector = MosaicDefinitionCreationTransactionBuffer.createDeadlineVector(builder, UInt64.fromBigInteger(deadlineBigInt));
        int feeVector = MosaicDefinitionCreationTransactionBuffer.createFeeVector(builder, fee);
        int mosaicIdVector = MosaicDefinitionCreationTransactionBuffer.createParentIdVector(builder, UInt64.fromBigInteger(this.mosaicId.getId()));
        int namespaceIdVector = MosaicDefinitionCreationTransactionBuffer.createParentIdVector(builder, UInt64.fromBigInteger(this.namespaceId.getId()));
        int durationVector = MosaicDefinitionCreationTransactionBuffer.createDurationVector(builder, UInt64.fromBigInteger(this.mosaicProperties.getDuration()));
        int fixSize = 149;
        int name = builder.createString((CharSequence)this.mosaicName);
        MosaicDefinitionCreationTransactionBuffer.startMosaicDefinitionCreationTransactionBuffer(builder);
        MosaicDefinitionCreationTransactionBuffer.addSize(builder, fixSize + this.mosaicName.length());
        MosaicDefinitionCreationTransactionBuffer.addSignature(builder, signatureVector);
        MosaicDefinitionCreationTransactionBuffer.addSigner(builder, signerVector);
        MosaicDefinitionCreationTransactionBuffer.addVersion(builder, version);
        MosaicDefinitionCreationTransactionBuffer.addType(builder, this.getType().getValue());
        MosaicDefinitionCreationTransactionBuffer.addFee(builder, feeVector);
        MosaicDefinitionCreationTransactionBuffer.addDeadline(builder, deadlineVector);
        MosaicDefinitionCreationTransactionBuffer.addMosaicId(builder, mosaicIdVector);
        MosaicDefinitionCreationTransactionBuffer.addParentId(builder, namespaceIdVector);
        MosaicDefinitionCreationTransactionBuffer.addMosaicNameLength(builder, this.mosaicName.length());
        MosaicDefinitionCreationTransactionBuffer.addNumOptionalProperties(builder, 1);
        MosaicDefinitionCreationTransactionBuffer.addFlags(builder, flags);
        MosaicDefinitionCreationTransactionBuffer.addDivisibility(builder, this.mosaicProperties.getDivisibility());
        MosaicDefinitionCreationTransactionBuffer.addMosaicName(builder, name);
        MosaicDefinitionCreationTransactionBuffer.addIndicateDuration(builder, 2);
        MosaicDefinitionCreationTransactionBuffer.addDuration(builder, durationVector);
        int codedTransaction = MosaicDefinitionCreationTransactionBuffer.endMosaicDefinitionCreationTransactionBuffer(builder);
        builder.finish(codedTransaction);
        return this.schema.serialize(builder.sizedByteArray());
    }
}

