/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class MosaicBuffer
extends Table {
    public static MosaicBuffer getRootAsMosaicBuffer(ByteBuffer _bb) {
        return MosaicBuffer.getRootAsMosaicBuffer(_bb, new MosaicBuffer());
    }

    public static MosaicBuffer getRootAsMosaicBuffer(ByteBuffer _bb, MosaicBuffer obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public static int createMosaicBuffer(FlatBufferBuilder builder, int idOffset, int amountOffset) {
        builder.startObject(2);
        MosaicBuffer.addAmount(builder, amountOffset);
        MosaicBuffer.addId(builder, idOffset);
        return MosaicBuffer.endMosaicBuffer(builder);
    }

    public static void startMosaicBuffer(FlatBufferBuilder builder) {
        builder.startObject(2);
    }

    public static void addId(FlatBufferBuilder builder, int idOffset) {
        builder.addOffset(0, idOffset, 0);
    }

    public static int createIdVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startIdVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addAmount(FlatBufferBuilder builder, int amountOffset) {
        builder.addOffset(1, amountOffset, 0);
    }

    public static int createAmountVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startAmountVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endMosaicBuffer(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public MosaicBuffer __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public long id(int j) {
        int o = this.__offset(4);
        return o != 0 ? (long)this.bb.getInt(this.__vector(o) + j * 4) & 0xFFFFFFFFL : 0L;
    }

    public int idLength() {
        int o = this.__offset(4);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer idAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 4);
    }

    public long amount(int j) {
        int o = this.__offset(6);
        return o != 0 ? (long)this.bb.getInt(this.__vector(o) + j * 4) & 0xFFFFFFFFL : 0L;
    }

    public int amountLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer amountAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 4);
    }
}

