/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.namespace;

import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.model.namespace.NamespaceType;
import java.math.BigInteger;
import java.util.List;

public class NamespaceInfo {
    private final boolean active;
    private final Integer index;
    private final String metaId;
    private final NamespaceType type;
    private final Integer depth;
    private final List<NamespaceId> levels;
    private final NamespaceId parentId;
    private final PublicAccount owner;
    private final BigInteger startHeight;
    private final BigInteger endHeight;

    public NamespaceInfo(boolean active, Integer index, String metaId, NamespaceType type, Integer depth, List<NamespaceId> levels, NamespaceId parentId, PublicAccount owner, BigInteger startHeight, BigInteger endHeight) {
        this.active = active;
        this.index = index;
        this.metaId = metaId;
        this.type = type;
        this.depth = depth;
        this.levels = levels;
        this.parentId = parentId;
        this.owner = owner;
        this.startHeight = startHeight;
        this.endHeight = endHeight;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isExpired() {
        return !this.active;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getMetaId() {
        return this.metaId;
    }

    public NamespaceType getType() {
        return this.type;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public List<NamespaceId> getLevels() {
        return this.levels;
    }

    public PublicAccount getOwner() {
        return this.owner;
    }

    public BigInteger getStartHeight() {
        return this.startHeight;
    }

    public BigInteger getEndHeight() {
        return this.endHeight;
    }

    public NamespaceId getId() {
        return this.levels.get(this.levels.size() - 1);
    }

    public boolean isRoot() {
        return this.type == NamespaceType.RootNamespace;
    }

    public boolean isSubnamespace() {
        return this.type == NamespaceType.SubNamespace;
    }

    public NamespaceId parentNamespaceId() {
        if (this.isRoot()) {
            throw new Error("Is A Root Namespace");
        }
        return this.parentId;
    }
}

