/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.model.namespace;

import io.nem.sdk.model.transaction.IdGenerator;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class NamespaceId {
    private final BigInteger id;
    private final Optional<String> fullName;

    public NamespaceId(String id) {
        this.id = IdGenerator.generateNamespaceId(id);
        this.fullName = Optional.of(id);
    }

    public NamespaceId(BigInteger id) {
        this.id = id;
        this.fullName = Optional.empty();
    }

    public BigInteger getId() {
        return this.id;
    }

    public Optional<String> getFullName() {
        return this.fullName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamespaceId)) {
            return false;
        }
        NamespaceId namespaceId1 = (NamespaceId)o;
        return Objects.equals(this.id, namespaceId1.id);
    }
}

